/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.editor.rendering.MathObject;
import jscl.math.Arithmetic;
import jscl.math.Expression;
import jscl.math.GenericVariable;
import jscl.math.JSCLBoolean;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.NotBooleanException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NotVectorException;
import jscl.math.Power;
import jscl.math.Variable;

public abstract class Generic
implements Arithmetic,
Comparable,
MathObject {
    public abstract Generic add(Generic var1);

    public Generic subtract(Generic generic) {
        return this.add(generic.negate());
    }

    public abstract Generic multiply(Generic var1);

    public boolean multiple(Generic generic) throws ArithmeticException {
        return true;
    }

    public abstract Generic divide(Generic var1) throws ArithmeticException;

    @Override
    public Arithmetic add(Arithmetic arithmetic) {
        return this.add((Generic)arithmetic);
    }

    @Override
    public Arithmetic subtract(Arithmetic arithmetic) {
        return this.subtract((Generic)arithmetic);
    }

    @Override
    public Arithmetic multiply(Arithmetic arithmetic) {
        return this.multiply((Generic)arithmetic);
    }

    @Override
    public Arithmetic divide(Arithmetic arithmetic) throws ArithmeticException {
        return this.divide((Generic)arithmetic);
    }

    public Generic[] divideAndRemainder(Generic generic) throws ArithmeticException {
        return new Generic[]{this.divide(generic), JSCLInteger.valueOf(0L)};
    }

    public Generic remainder(Generic generic) throws ArithmeticException {
        return this.divideAndRemainder(generic)[1];
    }

    public Generic inverse() {
        return JSCLInteger.valueOf(1L).divide(this);
    }

    public abstract Generic gcd(Generic var1);

    public Generic scm(Generic generic) {
        return this.divide(this.gcd(generic)).multiply(generic);
    }

    public abstract Generic gcd();

    public Generic[] gcdAndNormalize() {
        Generic generic = this.gcd();
        if (generic.signum() == 0) {
            return new Generic[]{generic, this};
        }
        if (generic.signum() != this.signum()) {
            generic = generic.negate();
        }
        return new Generic[]{generic, this.divide(generic)};
    }

    public Generic normalize() {
        return this.gcdAndNormalize()[1];
    }

    public Generic pow(int n) {
        return this.pow(JSCLInteger.valueOf(n));
    }

    public Generic pow(JSCLInteger jSCLInteger) {
        Generic generic;
        if (jSCLInteger.signum() < 0) {
            throw new ArithmeticException();
        }
        if (jSCLInteger.signum() == 0) {
            generic = JSCLInteger.valueOf(1L);
        } else {
            JSCLInteger[] jSCLIntegerArray = jSCLInteger.divideAndRemainder(JSCLInteger.valueOf(2L));
            if (jSCLIntegerArray[1].signum() == 0) {
                Generic generic2 = this.pow(jSCLIntegerArray[0]);
                generic = generic2.multiply(generic2);
            } else {
                generic = this.multiply(this.pow(jSCLInteger.subtract(JSCLInteger.valueOf(1L))));
            }
        }
        return generic;
    }

    public Generic abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public abstract Generic negate();

    public abstract int signum();

    public abstract int degree();

    public abstract Generic antiderivative(Variable var1) throws NotIntegrableException;

    public abstract Generic derivative(Variable var1);

    public abstract Generic substitute(Variable var1, Generic var2);

    public abstract Generic function(Variable var1);

    public abstract Generic expand();

    public abstract Generic factorize();

    public abstract Generic elementary();

    public abstract Generic simplify();

    public abstract Generic numeric();

    public abstract Generic valueof(Generic var1);

    public abstract Generic[] sumValue();

    public abstract Generic[] productValue() throws NotProductException;

    public abstract Power powerValue() throws NotPowerException;

    public abstract Expression expressionValue() throws NotExpressionException;

    public abstract JSCLInteger integerValue() throws NotIntegerException;

    public JSCLBoolean booleanValue() throws NotBooleanException {
        try {
            return JSCLBoolean.valueOf(this.integerValue().signum() != 0);
        }
        catch (NotIntegerException notIntegerException) {
            throw new NotBooleanException();
        }
    }

    public JSCLVector vectorValue() throws NotVectorException {
        Generic generic = GenericVariable.content(this);
        if (generic instanceof JSCLVector) {
            return (JSCLVector)generic;
        }
        throw new NotVectorException();
    }

    public abstract Variable variableValue() throws NotVariableException;

    public abstract Variable[] variables();

    public abstract boolean isPolynomial(Variable var1);

    public abstract boolean isConstant(Variable var1);

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isOne() {
        return this.equals(JSCLInteger.valueOf(1L));
    }

    public boolean isIdentity(Variable variable) {
        try {
            return this.variableValue().isIdentity(variable);
        }
        catch (NotVariableException notVariableException) {
            return false;
        }
    }

    public abstract int compareTo(Generic var1);

    public int compareTo(Object object) {
        return this.compareTo((Generic)object);
    }

    public boolean equals(Object object) {
        if (object instanceof Generic) {
            return this.compareTo((Generic)object) == 0;
        }
        return false;
    }

    public abstract String toMathML();
}

