/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Iterator;
import jscl.math.Debug;
import jscl.math.Divisor;
import jscl.math.Expression;
import jscl.math.ExpressionVariable;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.IntegerDivisor;
import jscl.math.JSCLInteger;
import jscl.math.Linearization;
import jscl.math.NotDivisibleException;
import jscl.math.NotIntegerException;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.util.ArrayComparator;

public class Factorization {
    Polynomial factory;
    Generic result;
    private static final String ter = "t";

    Factorization(Polynomial polynomial) {
        this.factory = polynomial;
    }

    public static Generic compute(Generic generic) {
        try {
            return GenericVariable.content(Factorization.factorize(generic.integerValue()));
        }
        catch (NotIntegerException notIntegerException) {
            Factorization factorization = new Factorization(Polynomial.factory(generic.variables(), Monomial.iteratorOrdering, -1));
            factorization.computeValue(generic);
            return factorization.getValue();
        }
    }

    static Generic factorize(JSCLInteger jSCLInteger) {
        Generic[] genericArray = jSCLInteger.gcdAndNormalize();
        Generic generic = genericArray[1];
        Generic generic2 = JSCLInteger.valueOf(1L);
        Generic generic3 = JSCLInteger.valueOf(2L);
        while (generic.compareTo(JSCLInteger.valueOf(1L)) > 0) {
            Generic[] genericArray2 = generic.divideAndRemainder(generic3);
            if (genericArray2[0].compareTo(generic3) < 0) {
                generic3 = generic;
                genericArray2 = generic.divideAndRemainder(generic3);
            }
            if (genericArray2[1].signum() == 0) {
                generic2 = ((Generic)generic2).multiply(Factorization.expression(generic3, true));
                generic = genericArray2[0];
                continue;
            }
            generic3 = generic3.add(JSCLInteger.valueOf(1L));
        }
        return ((Generic)generic2).multiply(genericArray[0]);
    }

    void computeValue(Generic generic) {
        Debug.println("factorization");
        Polynomial[] polynomialArray = this.factory.valueof(generic).gcdAndNormalize();
        Monomial monomial = polynomialArray[1].monomialGcd();
        Polynomial polynomial = polynomialArray[1].divide(monomial);
        Generic generic2 = JSCLInteger.valueOf(1L);
        Divisor[] divisorArray = new Divisor[2];
        Monomial[] monomialArray = new Monomial[2];
        Monomial[] monomialArray2 = new Monomial[2];
        divisorArray[1] = new Divisor(polynomial.head().monomial());
        block0: while (divisorArray[1].hasNext()) {
            monomialArray[1] = (Monomial)divisorArray[1].next();
            monomialArray2[1] = divisorArray[1].complementary();
            divisorArray[0] = new Divisor(polynomial.tail().monomial());
            while (divisorArray[0].hasNext()) {
                monomialArray[0] = (Monomial)divisorArray[0].next();
                monomialArray2[0] = divisorArray[0].complementary();
                if (monomialArray[1].compareTo(monomialArray[0]) <= 0) continue block0;
                Debug.println(Factorization.toString(monomialArray) + " * " + Factorization.toString(monomialArray2) + " = " + polynomial);
                if (ArrayComparator.comparator.compare(monomialArray2, monomialArray) < 0) {
                    generic2 = generic2.multiply(Factorization.expression(polynomial.genericValue()));
                    break block0;
                }
                Debug.increment();
                Polynomial[] polynomialArray2 = Factorization.remainder(polynomial, Factorization.polynomial(polynomial, monomialArray), Factorization.terminator(polynomial));
                Debug.decrement();
                if (polynomialArray2[0].signum() != 0) continue;
                generic2 = generic2.multiply(Factorization.expression(polynomialArray2[1].genericValue()));
                polynomial = polynomialArray2[2];
                divisorArray[1].divide();
                divisorArray[0].divide();
                continue block0;
            }
        }
        this.result = generic2.multiply(polynomialArray[0].multiply(monomial).genericValue());
    }

    static Polynomial[] remainder(Polynomial polynomial, Polynomial polynomial2, Generic[] genericArray) {
        Polynomial polynomial3 = polynomial.valueof(JSCLInteger.valueOf(0L));
        Generic[] genericArray2 = Basis.augment(genericArray, polynomial.remainderUpToCoefficient(polynomial2).elements());
        Variable[] variableArray = Basis.augmentUnknown(new Variable[0], polynomial2.elements());
        Generic[][] genericArray3 = variableArray[variableArray.length - 1];
        System.arraycopy(variableArray, 0, variableArray, 1, variableArray.length - 1);
        variableArray[0] = genericArray3;
        genericArray3 = Linearization.compute(Basis.compute(genericArray2, variableArray, Monomial.lexicographic, 0, 4).elements(), variableArray);
        for (int i = 0; i < genericArray3.length; ++i) {
            Polynomial polynomial4 = Factorization.substitute(polynomial2, genericArray3[i], variableArray);
            try {
                return new Polynomial[]{polynomial3, polynomial4, polynomial.divide(polynomial4)};
            }
            catch (NotDivisibleException notDivisibleException) {
                continue;
            }
        }
        return new Polynomial[]{polynomial, polynomial3, polynomial3};
    }

    static Polynomial substitute(Polynomial polynomial, Generic[] genericArray, Variable[] variableArray) {
        Generic[] genericArray2 = new Generic[]{polynomial.genericValue()};
        return polynomial.valueof(Basis.compute(Basis.augment(genericArray, genericArray2), Basis.augmentUnknown(variableArray, genericArray2)).elements()[0]);
    }

    static Polynomial polynomial(Polynomial polynomial, Monomial[] monomialArray) {
        Polynomial polynomial2 = polynomial.valueof(JSCLInteger.valueOf(0L));
        Iterator iterator = monomialArray[1].iterator(monomialArray[0]);
        int n = 0;
        while (iterator.hasNext()) {
            Monomial monomial = (Monomial)iterator.next();
            TechnicalVariable technicalVariable = iterator.hasNext() ? new TechnicalVariable(ter, new int[]{n}) : new TechnicalVariable(ter);
            polynomial2 = polynomial2.add(polynomial2.valueof(monomial).multiply(technicalVariable.expressionValue()));
            ++n;
        }
        return polynomial2;
    }

    static Generic[] terminator(Polynomial polynomial) {
        Generic[] genericArray = new Generic[2];
        genericArray[1] = Factorization.terminator(polynomial.head().coef().abs(), new TechnicalVariable(ter), false);
        genericArray[0] = Factorization.terminator(polynomial.tail().coef(), new TechnicalVariable(ter, new int[]{0}), true);
        return genericArray;
    }

    static Generic terminator(Generic generic, Variable variable, boolean bl) {
        Expression expression = variable.expressionValue();
        Generic generic2 = JSCLInteger.valueOf(1L);
        IntegerDivisor integerDivisor = IntegerDivisor.create(generic.integerValue());
        while (integerDivisor.hasNext()) {
            Generic generic3 = (Generic)integerDivisor.next();
            generic2 = generic2.multiply(((Generic)expression).subtract(generic3));
            if (bl) continue;
            generic2 = generic2.multiply(((Generic)expression).add(generic3));
        }
        return generic2;
    }

    static Generic expression(Generic generic) {
        return Factorization.expression(generic, false);
    }

    static Generic expression(Generic generic, boolean bl) {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return generic;
        }
        return GenericVariable.valueOf(generic, bl).expressionValue();
    }

    static String toString(Monomial[] monomialArray) {
        return "{" + monomialArray[0] + ", " + monomialArray[1] + "}";
    }

    Generic getValue() {
        return ExpressionVariable.content(this.result);
    }
}

