/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Debug;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.PolynomialWithSyzygy;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Log;
import jscl.math.function.Pow;
import jscl.math.function.Root;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;

public class Antiderivative {
    UnivariatePolynomial factory;
    PolynomialWithSyzygy syzygy;
    Generic result;

    Antiderivative(Variable variable) {
        this.factory = (UnivariatePolynomial)Polynomial.factory(variable);
        this.syzygy = (PolynomialWithSyzygy)PolynomialWithSyzygy.factory(variable);
    }

    public static Generic compute(Frac frac, Variable variable) {
        Antiderivative antiderivative = new Antiderivative(variable);
        antiderivative.compute(frac);
        return antiderivative.getValue();
    }

    public static Generic compute(Root root, Variable variable) throws NotIntegrableException {
        int n = root.degree();
        Generic[] genericArray = root.parameters();
        boolean bl = n > 0;
        bl = bl && genericArray[0].negate().isIdentity(variable);
        for (int i = 1; i < n; ++i) {
            bl = bl && genericArray[i].signum() == 0;
        }
        boolean bl2 = bl = bl && genericArray[n].compareTo(JSCLInteger.valueOf(1L)) == 0;
        if (bl) {
            return new Pow(genericArray[0].negate(), new Inv(JSCLInteger.valueOf(n)).evaluate()).antiderivative(0);
        }
        throw new NotIntegrableException();
    }

    void compute(Frac frac) {
        Debug.println("antiderivative");
        Debug.increment();
        Generic[] genericArray = frac.parameters();
        Generic[] genericArray2 = this.reduce(genericArray[0], genericArray[1]);
        genericArray2 = this.divideAndRemainder(genericArray2[0], genericArray2[1]);
        Generic generic = new Inv(genericArray2[2]).evaluate();
        Generic generic2 = genericArray2[0].multiply(generic);
        Generic generic3 = genericArray2[1].multiply(generic);
        this.result = generic2.antiderivative(this.factory.variable()).add(this.hermite(generic3, genericArray[1]));
        Debug.decrement();
    }

    Generic[] reduce(Generic generic, Generic generic2) {
        Debug.println("reduce(" + generic + ", " + generic2 + ")");
        Polynomial polynomial = this.factory.valueof(generic);
        Polynomial polynomial2 = this.factory.valueof(generic2);
        Polynomial polynomial3 = polynomial.gcd(polynomial2);
        return new Generic[]{polynomial.divide(polynomial3).genericValue(), polynomial2.divide(polynomial3).genericValue()};
    }

    Generic[] divideAndRemainder(Generic generic, Generic generic2) {
        Debug.println("divideAndRemainder(" + generic + ", " + generic2 + ")");
        PolynomialWithSyzygy polynomialWithSyzygy = this.syzygy.valueof(generic, 0);
        PolynomialWithSyzygy polynomialWithSyzygy2 = this.syzygy.valueof(generic2, 1);
        PolynomialWithSyzygy polynomialWithSyzygy3 = (PolynomialWithSyzygy)((Polynomial)polynomialWithSyzygy).remainderUpToCoefficient(polynomialWithSyzygy2);
        return new Generic[]{polynomialWithSyzygy3.syzygy[1].genericValue().negate(), polynomialWithSyzygy3.genericValue(), polynomialWithSyzygy3.syzygy[0].genericValue()};
    }

    Generic[] bezout(Generic generic, Generic generic2) {
        Debug.println("bezout(" + generic + ", " + generic2 + ")");
        PolynomialWithSyzygy polynomialWithSyzygy = this.syzygy.valueof(generic, 0);
        PolynomialWithSyzygy polynomialWithSyzygy2 = this.syzygy.valueof(generic2, 1);
        PolynomialWithSyzygy polynomialWithSyzygy3 = (PolynomialWithSyzygy)((Polynomial)polynomialWithSyzygy).gcd(polynomialWithSyzygy2);
        return new Generic[]{polynomialWithSyzygy3.syzygy[0].genericValue(), polynomialWithSyzygy3.syzygy[1].genericValue(), polynomialWithSyzygy3.genericValue()};
    }

    Generic hermite(Generic generic, Generic generic2) {
        Debug.println("hermite(" + generic + ", " + generic2 + ")");
        UnivariatePolynomial[] univariatePolynomialArray = ((UnivariatePolynomial)this.factory.valueof(generic2)).squarefreeDecomposition();
        int n = univariatePolynomialArray.length - 1;
        if (n < 2) {
            return this.trager(generic, generic2);
        }
        Generic generic3 = univariatePolynomialArray[0].genericValue();
        for (int i = 1; i < n; ++i) {
            generic3 = generic3.multiply(univariatePolynomialArray[i].genericValue().pow(i));
        }
        Generic generic4 = univariatePolynomialArray[n].genericValue();
        Generic generic5 = univariatePolynomialArray[n].derivative().genericValue();
        Generic generic6 = generic3.multiply(generic5);
        Generic[] genericArray = this.bezout(generic6, generic4);
        Generic generic7 = genericArray[0].multiply(generic);
        Generic generic8 = genericArray[1].multiply(generic);
        Generic generic9 = genericArray[2];
        genericArray = this.divideAndRemainder(generic7, generic4);
        generic7 = genericArray[1];
        generic8 = generic8.multiply(genericArray[2]).add(genericArray[0].multiply(generic6));
        generic9 = new Inv(generic9.multiply(genericArray[2]).multiply(JSCLInteger.valueOf(1 - n))).evaluate();
        generic7 = generic7.multiply(generic9);
        generic8 = generic8.multiply(generic9);
        Generic generic10 = ((UnivariatePolynomial)this.factory.valueof(generic7)).derivative().genericValue();
        return new Frac(generic7, generic4.pow(n - 1)).evaluate().add(this.hermite(JSCLInteger.valueOf(1 - n).multiply(generic8).subtract(generic3.multiply(generic10)), generic3.multiply(generic4.pow(n - 1))));
    }

    Generic trager(Generic generic, Generic generic2) {
        Debug.println("trager(" + generic + ", " + generic2 + ")");
        TechnicalVariable technicalVariable = new TechnicalVariable("t");
        UnivariatePolynomial univariatePolynomial = (UnivariatePolynomial)this.factory.valueof(generic2);
        UnivariatePolynomial univariatePolynomial2 = (UnivariatePolynomial)this.factory.valueof(generic).subtract(univariatePolynomial.derivative().multiply(technicalVariable.expressionValue()));
        UnivariatePolynomial[] univariatePolynomialArray = univariatePolynomial.remainderSequence(univariatePolynomial2);
        Polynomial polynomial = UnivariatePolynomial.factory(technicalVariable);
        for (int i = 0; i < univariatePolynomialArray.length; ++i) {
            if (univariatePolynomialArray[i] == null) continue;
            univariatePolynomialArray[i] = (UnivariatePolynomial)polynomial.valueof((i > 0 ? univariatePolynomialArray[i].normalize() : univariatePolynomialArray[i]).genericValue());
        }
        UnivariatePolynomial[] univariatePolynomialArray2 = univariatePolynomialArray[0].squarefreeDecomposition();
        int n = univariatePolynomialArray2.length - 1;
        Generic generic3 = JSCLInteger.valueOf(0L);
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < univariatePolynomialArray2[i].degree(); ++j) {
                Generic generic4 = new Root(univariatePolynomialArray2[i], j).evaluate();
                generic3 = ((Generic)generic3).add(generic4.multiply(new Log(i == univariatePolynomial.degree() ? generic2 : univariatePolynomialArray[i].substitute(generic4)).evaluate()));
            }
        }
        return generic3;
    }

    Generic getValue() {
        return this.result;
    }
}

