/*
 * Decompiled with CFR 0.152.
 */
package jscl.text;

import jscl.math.Generic;
import jscl.math.function.Abs;
import jscl.math.function.Comparison;
import jscl.math.function.Conjugate;
import jscl.math.function.Cubic;
import jscl.math.function.Exp;
import jscl.math.function.Function;
import jscl.math.function.Log;
import jscl.math.function.Sqrt;
import jscl.math.function.bool.And;
import jscl.math.function.bool.Implies;
import jscl.math.function.bool.Not;
import jscl.math.function.bool.Or;
import jscl.math.function.bool.Xor;
import jscl.math.function.hyperbolic.Acosh;
import jscl.math.function.hyperbolic.Acoth;
import jscl.math.function.hyperbolic.Asinh;
import jscl.math.function.hyperbolic.Atanh;
import jscl.math.function.hyperbolic.Cosh;
import jscl.math.function.hyperbolic.Coth;
import jscl.math.function.hyperbolic.Sinh;
import jscl.math.function.hyperbolic.Tanh;
import jscl.math.function.trigonometric.Acos;
import jscl.math.function.trigonometric.Acot;
import jscl.math.function.trigonometric.Asin;
import jscl.math.function.trigonometric.Atan;
import jscl.math.function.trigonometric.Cos;
import jscl.math.function.trigonometric.Cot;
import jscl.math.function.trigonometric.Sin;
import jscl.math.function.trigonometric.Tan;
import jscl.text.Identifier;
import jscl.text.ParameterList;
import jscl.text.ParseException;
import jscl.text.Parser;

class UsualFunctionParser
extends Parser {
    public static final Parser parser = new UsualFunctionParser();
    private static String[] na = new String[]{"sin", "cos", "tan", "cot", "asin", "acos", "atan", "acot", "log", "exp", "sqrt", "cubic", "sinh", "cosh", "tanh", "coth", "asinh", "acosh", "atanh", "acoth", "abs", "conjugate", "eq", "neq", "leq", "lt", "geq", "gt", "approx", "and", "or", "xor", "not", "implies"};

    private UsualFunctionParser() {
    }

    @Override
    public Object parse(String string, int[] nArray) throws ParseException {
        Generic[] genericArray;
        int n = nArray[0];
        String string2 = (String)Identifier.parser.parse(string, nArray);
        if (!UsualFunctionParser.valid(string2)) {
            nArray[0] = n;
            throw new ParseException();
        }
        try {
            genericArray = (Generic[])ParameterList.parser.parse(string, nArray);
        }
        catch (ParseException parseException) {
            nArray[0] = n;
            throw parseException;
        }
        Function function = null;
        if (string2.compareTo("sin") == 0) {
            function = new Sin(genericArray[0]);
        } else if (string2.compareTo("cos") == 0) {
            function = new Cos(genericArray[0]);
        } else if (string2.compareTo("tan") == 0) {
            function = new Tan(genericArray[0]);
        } else if (string2.compareTo("cot") == 0) {
            function = new Cot(genericArray[0]);
        } else if (string2.compareTo("asin") == 0) {
            function = new Asin(genericArray[0]);
        } else if (string2.compareTo("acos") == 0) {
            function = new Acos(genericArray[0]);
        } else if (string2.compareTo("atan") == 0) {
            function = new Atan(genericArray[0]);
        } else if (string2.compareTo("acot") == 0) {
            function = new Acot(genericArray[0]);
        } else if (string2.compareTo("log") == 0) {
            function = new Log(genericArray[0]);
        } else if (string2.compareTo("exp") == 0) {
            function = new Exp(genericArray[0]);
        } else if (string2.compareTo("sqrt") == 0) {
            function = new Sqrt(genericArray[0]);
        } else if (string2.compareTo("cubic") == 0) {
            function = new Cubic(genericArray[0]);
        } else if (string2.compareTo("sinh") == 0) {
            function = new Sinh(genericArray[0]);
        } else if (string2.compareTo("cosh") == 0) {
            function = new Cosh(genericArray[0]);
        } else if (string2.compareTo("tanh") == 0) {
            function = new Tanh(genericArray[0]);
        } else if (string2.compareTo("coth") == 0) {
            function = new Coth(genericArray[0]);
        } else if (string2.compareTo("asinh") == 0) {
            function = new Asinh(genericArray[0]);
        } else if (string2.compareTo("acosh") == 0) {
            function = new Acosh(genericArray[0]);
        } else if (string2.compareTo("atanh") == 0) {
            function = new Atanh(genericArray[0]);
        } else if (string2.compareTo("acoth") == 0) {
            function = new Acoth(genericArray[0]);
        } else if (string2.compareTo("abs") == 0) {
            function = new Abs(genericArray[0]);
        } else if (string2.compareTo("conjugate") == 0) {
            function = new Conjugate(genericArray[0]);
        } else if (string2.compareTo("eq") == 0 || string2.compareTo("neq") == 0 || string2.compareTo("leq") == 0 || string2.compareTo("lt") == 0 || string2.compareTo("geq") == 0 || string2.compareTo("gt") == 0 || string2.compareTo("approx") == 0) {
            function = new Comparison(string2, genericArray[0], genericArray[1]);
        } else if (string2.compareTo("and") == 0) {
            function = new And(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("or") == 0) {
            function = new Or(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("xor") == 0) {
            function = new Xor(genericArray[0], genericArray[1]);
        } else if (string2.compareTo("not") == 0) {
            function = new Not(genericArray[0]);
        } else if (string2.compareTo("implies") == 0) {
            function = new Implies(genericArray[0], genericArray[1]);
        }
        return function;
    }

    static boolean valid(String string) {
        for (int i = 0; i < na.length; ++i) {
            if (string.compareTo(na[i]) != 0) continue;
            return true;
        }
        return false;
    }
}

