/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.List;
import jscl.math.Generic;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ReducedRowEchelonForm {
    List content = new ArrayList();

    ReducedRowEchelonForm(List list) {
        this.content.addAll(list);
    }

    static List compute(List list) {
        ReducedRowEchelonForm reducedRowEchelonForm = new ReducedRowEchelonForm(list);
        reducedRowEchelonForm.compute();
        return reducedRowEchelonForm.content;
    }

    void compute() {
        int n;
        int n2 = this.content.size();
        for (n = 0; n < n2; ++n) {
            this.reduce(n, false);
        }
        for (n = n2 - 1; n >= 0; --n) {
            this.reduce(n, true);
        }
    }

    void reduce(int n, boolean bl) {
        Polynomial polynomial = this.polynomial(n);
        polynomial = polynomial.normalize().freeze();
        this.content.set(n, polynomial);
        if (polynomial.signum() == 0) {
            return;
        }
        Monomial monomial = polynomial.head().monomial();
        int n2 = bl ? 0 : n + 1;
        int n3 = bl ? n : this.content.size();
        for (int i = n2; i < n3; ++i) {
            Polynomial polynomial2 = this.polynomial(i);
            Generic generic = polynomial2.coefficient(monomial);
            if (generic.signum() == 0) continue;
            this.content.set(i, polynomial2.reduce(generic, polynomial));
        }
    }

    Polynomial polynomial(int n) {
        return (Polynomial)this.content.get(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = this.content.size();
        for (int i = 0; i < n; ++i) {
            Polynomial polynomial = this.polynomial(i);
            stringBuffer.append(i > 0 ? ", " : "").append(polynomial);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

