/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.ArrayList;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Variable;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.groebner.Standard;
import jscl.util.ArrayUtils;

public class Basis {
    public static final int DATA_STRUCT = 3;
    public static final int ARRAY_DECLINED = 0;
    public static final int ARRAY = 1;
    public static final int TREE = 2;
    public static final int LIST = 3;
    public static final int DEGREE = 4;
    public static final int DEFINING_EQS = 8;
    public static final int POWER_SIZE = 48;
    public static final int POWER_32 = 0;
    public static final int POWER_8 = 16;
    public static final int POWER_2 = 32;
    public static final int POWER_2_DEFINED = 48;
    public static final int GEO_BUCKETS = 64;
    public static final int ALGORITHM = 384;
    public static final int BUCHBERGER = 0;
    public static final int F4 = 128;
    public static final int BLOCK = 256;
    public static final int INSTRUMENTED = 512;
    public static final int GM_SETTING = 1024;
    public static final int SUGAR = 2048;
    public static final int FUSSY = 4096;
    public static final int F4_SIMPLIFY = 8192;
    static final int DEFAULT = 3072;
    final Polynomial factory;
    final Generic[] element;

    public Basis(Generic[] genericArray, Polynomial polynomial) {
        this.element = genericArray;
        this.factory = polynomial;
    }

    public static Basis compute(Generic[] genericArray, Variable[] variableArray) {
        return Basis.compute(genericArray, variableArray, Monomial.lexicographic);
    }

    public static Basis compute(Generic[] genericArray, Variable[] variableArray, Ordering ordering) {
        return Basis.compute(genericArray, variableArray, ordering, 0);
    }

    public static Basis compute(Generic[] genericArray, Variable[] variableArray, Ordering ordering, int n) {
        return Basis.compute(genericArray, variableArray, ordering, n, 0);
    }

    public static Basis compute(Generic[] genericArray, Variable[] variableArray, Ordering ordering, int n, int n2) {
        return Basis.compute(genericArray, variableArray, ordering, n, n2, ((n2 ^= 0xC00) & 4) > 0, (n2 & 8) > 0);
    }

    static Basis compute(Generic[] genericArray, Variable[] variableArray, Ordering ordering, int n, int n2, boolean bl, boolean bl2) {
        if (bl) {
            return Basis.compute(Basis.compute(genericArray, variableArray, Monomial.degreeReverseLexicographic, n, n2, false, bl2).elements(), variableArray, ordering, n, n2, false, bl2);
        }
        return Standard.compute(new Basis(bl2 ? Basis.augment(Basis.defining(variableArray, n), genericArray) : genericArray, Polynomial.factory(variableArray, ordering, n, n2)), n2);
    }

    public Basis valueof(Generic[] genericArray) {
        return new Basis(genericArray, this.factory);
    }

    public Basis modulo(int n) {
        return new Basis(this.element, Polynomial.factory(this.factory, n));
    }

    public static Generic[] defining(Variable[] variableArray, int n) {
        Generic[] genericArray = new Generic[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            Expression expression = variableArray[i].expressionValue();
            genericArray[i] = ((Generic)expression).subtract(expression.pow(n));
        }
        return genericArray;
    }

    public static boolean compatible(Generic[] genericArray) {
        return genericArray.length <= 0 || genericArray[0].compareTo(JSCLInteger.valueOf(1L)) != 0;
    }

    public static Generic[] augment(Generic[] genericArray, Generic[] genericArray2) {
        return (Generic[])ArrayUtils.concat(genericArray, genericArray2, new Generic[genericArray.length + genericArray2.length]);
    }

    public static Variable[] augmentUnknown(Variable[] variableArray, Generic[] genericArray) {
        int n;
        Variable[] variableArray2 = Expression.variables(genericArray);
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (n = 0; n < variableArray.length; ++n) {
            arrayList.add(variableArray[n]);
        }
        n = 0;
        for (int i = 0; i < variableArray2.length; ++i) {
            Variable variable = variableArray2[i];
            if (arrayList.contains(variable)) continue;
            arrayList.add(n++, variable);
        }
        return (Variable[])ArrayUtils.toArray(arrayList, new Variable[arrayList.size()]);
    }

    public Generic[] elements() {
        return this.element;
    }

    public Ordering ordering() {
        return this.factory.ordering();
    }

    public Polynomial polynomial(Generic generic) {
        return this.factory.valueof(generic).normalize().freeze();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.element.length; ++i) {
            stringBuffer.append(this.polynomial(this.element[i])).append(i < this.element.length - 1 ? ", " : "");
        }
        stringBuffer.append("}");
        stringBuffer.append(", " + ArrayUtils.toString(this.factory.monomialFactory.unknown()));
        return stringBuffer.toString();
    }
}

