/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

final class ArrayPolynomial
extends Polynomial {
    Term[] content;
    int size;
    int degree;

    ArrayPolynomial(Monomial monomial, Generic generic) {
        super(monomial, generic);
    }

    ArrayPolynomial(int n, Monomial monomial, Generic generic) {
        this(monomial, generic);
        this.init(n);
    }

    @Override
    public int size() {
        return this.size;
    }

    void init(int n) {
        this.content = new Term[n];
        this.size = n;
    }

    void resize(int n) {
        int n2 = this.content.length;
        if (n < n2) {
            Term[] termArray = new Term[n];
            System.arraycopy(this.content, n2 - n, termArray, 0, n);
            this.content = termArray;
            this.size = n;
        }
    }

    @Override
    public Iterator iterator(boolean bl, Monomial monomial) {
        return new ContentIterator(bl, monomial);
    }

    int indexOf(Monomial monomial, boolean bl) {
        if (monomial == null) {
            return bl ? this.size : 0;
        }
        int n = Arrays.binarySearch(this.content, new Term(monomial, null));
        return n < 0 ? -n - 1 : (bl ? n : n + 1);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Term term;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomial arrayPolynomial = (ArrayPolynomial)polynomial;
        ArrayPolynomial arrayPolynomial2 = this.newinstance(this.size + arrayPolynomial.size);
        int n = arrayPolynomial2.size;
        int n2 = this.size;
        int n3 = arrayPolynomial.size;
        Term term2 = n2 > 0 ? this.content[--n2] : null;
        Term term3 = term = n3 > 0 ? arrayPolynomial.content[--n3] : null;
        while (term2 != null || term != null) {
            int n4;
            int n5 = term2 == null ? 1 : (n4 = term == null ? -1 : -this.ordering.compare(term2.monomial(), term.monomial()));
            if (n4 < 0) {
                arrayPolynomial2.content[--n] = term2;
                term2 = n2 > 0 ? this.content[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                arrayPolynomial2.content[--n] = term.negate();
                term = n3 > 0 ? arrayPolynomial.content[--n3] : null;
                continue;
            }
            Term term4 = term2.subtract(term);
            if (term4.signum() != 0) {
                arrayPolynomial2.content[--n] = term4;
            }
            term2 = n2 > 0 ? this.content[--n2] : null;
            term = n3 > 0 ? arrayPolynomial.content[--n3] : null;
        }
        arrayPolynomial2.resize(arrayPolynomial2.size - n);
        arrayPolynomial2.degree = ArrayPolynomial.degree(arrayPolynomial2);
        arrayPolynomial2.sugar = Math.max(this.sugar, arrayPolynomial.sugar);
        return arrayPolynomial2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Term term;
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        ArrayPolynomial arrayPolynomial = (ArrayPolynomial)polynomial;
        ArrayPolynomial arrayPolynomial2 = this.newinstance(this.size + arrayPolynomial.size);
        int n = arrayPolynomial2.size;
        int n2 = this.size;
        int n3 = arrayPolynomial.size;
        Term term2 = n2 > 0 ? this.content[--n2] : null;
        Term term3 = term = n3 > 0 ? arrayPolynomial.content[--n3].multiply(generic) : null;
        while (term2 != null || term != null) {
            int n4;
            int n5 = term2 == null ? 1 : (n4 = term == null ? -1 : -this.ordering.compare(term2.monomial(), term.monomial()));
            if (n4 < 0) {
                arrayPolynomial2.content[--n] = term2;
                term2 = n2 > 0 ? this.content[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                arrayPolynomial2.content[--n] = term.negate();
                term = n3 > 0 ? arrayPolynomial.content[--n3].multiply(generic) : null;
                continue;
            }
            Term term4 = term2.subtract(term);
            if (term4.signum() != 0) {
                arrayPolynomial2.content[--n] = term4;
            }
            term2 = n2 > 0 ? this.content[--n2] : null;
            term = n3 > 0 ? arrayPolynomial.content[--n3].multiply(generic) : null;
        }
        arrayPolynomial2.resize(arrayPolynomial2.size - n);
        arrayPolynomial2.degree = ArrayPolynomial.degree(arrayPolynomial2);
        arrayPolynomial2.sugar = Math.max(this.sugar, arrayPolynomial.sugar);
        return arrayPolynomial2;
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Term term;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        ArrayPolynomial arrayPolynomial = (ArrayPolynomial)polynomial;
        ArrayPolynomial arrayPolynomial2 = this.newinstance(this.size + arrayPolynomial.size);
        int n = arrayPolynomial2.size;
        int n2 = this.size;
        int n3 = arrayPolynomial.size;
        Term term2 = n2 > 0 ? this.content[--n2] : null;
        Term term3 = term = n3 > 0 ? arrayPolynomial.content[--n3].multiply(monomial, generic) : null;
        while (term2 != null || term != null) {
            int n4;
            int n5 = term2 == null ? 1 : (n4 = term == null ? -1 : -this.ordering.compare(term2.monomial(), term.monomial()));
            if (n4 < 0) {
                arrayPolynomial2.content[--n] = term2;
                term2 = n2 > 0 ? this.content[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                arrayPolynomial2.content[--n] = term.negate();
                term = n3 > 0 ? arrayPolynomial.content[--n3].multiply(monomial, generic) : null;
                continue;
            }
            Term term4 = term2.subtract(term);
            if (term4.signum() != 0) {
                arrayPolynomial2.content[--n] = term4;
            }
            term2 = n2 > 0 ? this.content[--n2] : null;
            term = n3 > 0 ? arrayPolynomial.content[--n3].multiply(monomial, generic) : null;
        }
        arrayPolynomial2.resize(arrayPolynomial2.size - n);
        arrayPolynomial2.degree = ArrayPolynomial.degree(arrayPolynomial2);
        arrayPolynomial2.sugar = Math.max(this.sugar, arrayPolynomial.sugar + monomial.degree());
        return arrayPolynomial2;
    }

    @Override
    public Polynomial multiply(Polynomial polynomial) {
        Polynomial polynomial2 = this.valueof(JSCLInteger.valueOf(0L));
        for (int i = 0; i < this.size; ++i) {
            Term term = this.content[i];
            polynomial2 = polynomial2.multiplyAndSubtract(term.monomial(), term.coef().negate(), polynomial);
        }
        return polynomial2;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomial arrayPolynomial = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomial.content[i] = this.content[i].multiply(generic);
        }
        arrayPolynomial.degree = this.degree;
        arrayPolynomial.sugar = this.sugar;
        return arrayPolynomial;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomial arrayPolynomial = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomial.content[i] = this.content[i].multiply(monomial);
        }
        arrayPolynomial.degree = this.degree + monomial.degree();
        arrayPolynomial.sugar = this.sugar + monomial.degree();
        return arrayPolynomial;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomial arrayPolynomial = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomial.content[i] = this.content[i].divide(generic);
        }
        arrayPolynomial.degree = this.degree;
        arrayPolynomial.sugar = this.sugar;
        return arrayPolynomial;
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomial arrayPolynomial = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            arrayPolynomial.content[i] = this.content[i].divide(monomial);
        }
        arrayPolynomial.degree = this.degree - monomial.degree();
        arrayPolynomial.sugar = this.sugar - monomial.degree();
        return arrayPolynomial;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        Generic generic = this.coefficient(JSCLInteger.valueOf(0L));
        for (int i = this.size - 1; i >= 0; --i) {
            generic = generic.gcd(this.content[i].coef());
        }
        return generic.signum() == this.signum() ? generic : generic.negate();
    }

    @Override
    public Monomial monomialGcd() {
        Monomial monomial = this.monomial(this.tail());
        for (int i = 0; i < this.size; ++i) {
            monomial = monomial.gcd(this.content[i].monomial());
        }
        return monomial;
    }

    @Override
    public int degree() {
        return this.degree;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        ArrayPolynomial arrayPolynomial = this.newinstance(0);
        arrayPolynomial.init(polynomial);
        return arrayPolynomial;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        ArrayPolynomial arrayPolynomial = this.newinstance(0);
        arrayPolynomial.init(generic);
        return arrayPolynomial;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        ArrayPolynomial arrayPolynomial = this.newinstance(0);
        arrayPolynomial.init(monomial);
        return arrayPolynomial;
    }

    @Override
    public Polynomial freeze() {
        return this;
    }

    @Override
    public Term head() {
        return this.size > 0 ? this.content[this.size - 1] : null;
    }

    @Override
    public Term tail() {
        return this.size > 0 ? this.content[0] : null;
    }

    void init(Polynomial polynomial) {
        ArrayPolynomial arrayPolynomial = (ArrayPolynomial)polynomial;
        this.init(arrayPolynomial.size);
        System.arraycopy(arrayPolynomial.content, 0, this.content, 0, this.size);
        this.degree = arrayPolynomial.degree;
        this.sugar = arrayPolynomial.sugar;
    }

    void init(Expression expression) {
        Generic generic;
        Comparable comparable;
        Object object;
        Object object2;
        int n;
        TreeMap<Object, Comparable> treeMap = new TreeMap<Object, Comparable>(this.ordering);
        int n2 = expression.size();
        for (n = 0; n < n2; ++n) {
            Comparable comparable2;
            object2 = expression.literal(n);
            JSCLInteger jSCLInteger = expression.coef(n);
            object = this.monomial((Literal)object2);
            comparable = this.coefficient(((Literal)(object2 = ((Literal)object2).divide(((Monomial)object).literalValue()))).degree() > 0 ? jSCLInteger.multiply(Expression.valueOf((Literal)object2)) : jSCLInteger);
            generic = (Generic)treeMap.get(object);
            Comparable comparable3 = comparable2 = generic == null ? comparable : generic.add((Generic)comparable);
            if (((Generic)comparable2).signum() == 0) {
                treeMap.remove(object);
                continue;
            }
            treeMap.put(object, comparable2);
        }
        this.init(treeMap.size());
        n = 0;
        object2 = treeMap.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            object = (Map.Entry)object2.next();
            comparable = (Monomial)object.getKey();
            generic = (Generic)object.getValue();
            this.content[i] = new Term((Monomial)comparable, generic);
            n = Math.max(n, ((Monomial)comparable).degree());
        }
        this.degree = ArrayPolynomial.degree(this);
        this.sugar = n;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic generic2 = this.coefficient(generic);
            if (generic2.signum() != 0) {
                this.init(1);
                this.content[0] = new Term(this.monomial(Literal.valueOf()), generic2);
            } else {
                this.init(0);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.init(1);
        this.content[0] = new Term(monomial, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected ArrayPolynomial newinstance(int n) {
        return new ArrayPolynomial(n, this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        int index;

        ContentIterator(boolean bl, Monomial monomial) {
            this.direction = bl;
            this.index = ArrayPolynomial.this.indexOf(monomial, bl);
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.index > 0 : this.index < ArrayPolynomial.this.size;
        }

        public Object next() {
            return this.direction ? ArrayPolynomial.this.content[--this.index] : ArrayPolynomial.this.content[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

