/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator.product;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Variable;
import jscl.math.function.ImplicitFunction;
import jscl.math.operator.VectorOperator;

public class GeometricProduct
extends VectorOperator {
    public static final ImplicitFunction.Curried cl = ImplicitFunction.apply("cl", new int[2]);

    public GeometricProduct(Generic generic, Generic generic2, Generic generic3) {
        super("geometric", new Generic[]{generic, generic2, generic3});
    }

    @Override
    public Generic compute() {
        int[] nArray = GeometricProduct.algebra(this.parameter[2]);
        if (this.parameter[0] instanceof JSCLVector && this.parameter[1] instanceof JSCLVector) {
            JSCLVector jSCLVector = (JSCLVector)this.parameter[0];
            JSCLVector jSCLVector2 = (JSCLVector)this.parameter[1];
            return jSCLVector.geometricProduct(jSCLVector2, nArray);
        }
        return this.expressionValue();
    }

    public static int[] algebra(Generic generic) {
        if (generic.signum() == 0) {
            return null;
        }
        Variable variable = generic.variableValue();
        if (variable instanceof ImplicitFunction) {
            Generic[] genericArray = ((ImplicitFunction)variable).parameters();
            int n = genericArray[0].integerValue().intValue();
            int n2 = genericArray[1].integerValue().intValue();
            if (variable.compareTo(cl.apply(new Generic[]{JSCLInteger.valueOf(n), JSCLInteger.valueOf(n2)}).variableValue()) == 0) {
                return new int[]{n, n2};
            }
        }
        throw new ArithmeticException();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 3;
        if (this.parameter[2].signum() == 0) {
            n = 2;
        }
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 3;
        if (this.parameter[2].signum() == 0) {
            n = 2;
        }
        stringBuffer.append("<apply>");
        stringBuffer.append("<ci>" + this.nameToMathML() + "</ci>");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new GeometricProduct(null, null, null);
    }
}

