/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.Variable;
import jscl.util.ArrayComparator;

public abstract class Operator
extends Variable {
    protected Generic[] parameter;

    public Operator(String string, Generic[] genericArray) {
        super(string);
        this.parameter = genericArray;
    }

    public Generic[] parameters() {
        return this.parameter;
    }

    public abstract Generic compute();

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Operator operator = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            operator.parameter[i] = this.parameter[i].substitute(variable, generic);
        }
        if (operator.isIdentity(variable)) {
            return generic;
        }
        return operator.compute();
    }

    @Override
    public Generic expand() {
        Operator operator = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            operator.parameter[i] = this.parameter[i].expand();
        }
        return operator.compute();
    }

    @Override
    public Generic factorize() {
        Operator operator = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            operator.parameter[i] = this.parameter[i].factorize();
        }
        return operator.expressionValue();
    }

    @Override
    public Generic elementary() {
        Operator operator = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            operator.parameter[i] = this.parameter[i].elementary();
        }
        return operator.expressionValue();
    }

    @Override
    public Generic simplify() {
        Operator operator = (Operator)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            operator.parameter[i] = this.parameter[i].simplify();
        }
        return operator.expressionValue();
    }

    @Override
    public Generic function(Variable variable) {
        throw new ArithmeticException();
    }

    @Override
    public Generic numeric() {
        throw new ArithmeticException();
    }

    @Override
    public boolean isConstant(Variable variable) {
        return !this.isIdentity(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Operator operator = (Operator)variable;
        n = this.name.compareTo(operator.name);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return ArrayComparator.comparator.compare(this.parameter, operator.parameter);
    }

    protected static Variable[] variables(JSCLVector jSCLVector) throws NotVariableException {
        Generic[] genericArray = jSCLVector.elements();
        Variable[] variableArray = new Variable[genericArray.length];
        for (int i = 0; i < genericArray.length; ++i) {
            variableArray[i] = genericArray[i].variableValue();
        }
        return variableArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply>");
        stringBuffer.append("<ci>" + this.nameToMathML() + "</ci>");
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }
}

