/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.Variable;
import jscl.math.operator.Operator;

public class Derivative
extends Operator {
    public Derivative(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        super("d", new Generic[]{generic, generic2, generic3, generic4});
    }

    @Override
    public Generic compute() {
        Variable variable = this.parameter[1].variableValue();
        try {
            int n = this.parameter[3].integerValue().intValue();
            Generic generic = this.parameter[0];
            for (int i = 0; i < n; ++i) {
                generic = generic.derivative(variable);
            }
            return generic.substitute(variable, this.parameter[2]);
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 4;
        if (this.parameter[3].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            n = 3;
            if (this.parameter[2].compareTo(this.parameter[1]) == 0) {
                n = 2;
            }
        }
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parameter[2].compareTo(this.parameter[1]) != 0) {
            stringBuffer.append("<apply>");
            stringBuffer.append(this.derivationToMathML());
            stringBuffer.append(this.parameter[2].toMathML());
            stringBuffer.append("</apply>");
        } else {
            stringBuffer.append(this.derivationToMathML());
        }
        return stringBuffer.toString();
    }

    String derivationToMathML() {
        Variable variable = this.parameter[1].variableValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply><diff/><bvar><degree>");
        stringBuffer.append(this.parameter[3].toMathML());
        stringBuffer.append("</degree>");
        stringBuffer.append(variable.toMathML());
        stringBuffer.append("</bvar>");
        stringBuffer.append(this.parameter[0].toMathML());
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Derivative(null, null, null, null);
    }
}

