/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.Variable;
import jscl.math.operator.Operator;

public class Binomial
extends Operator {
    public Binomial(Generic generic, Generic generic2) {
        super("C", new Generic[]{generic, generic2});
    }

    @Override
    public Generic compute() {
        try {
            JSCLInteger jSCLInteger = this.parameter[0].integerValue();
            JSCLInteger jSCLInteger2 = this.parameter[1].integerValue();
            return jSCLInteger.factorial().divide(jSCLInteger2.factorial().multiply(jSCLInteger.subtract(jSCLInteger2).factorial()));
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<msubsup>");
        stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
        stringBuffer.append(this.parameter[0].toMathML());
        stringBuffer.append(this.parameter[1].toMathML());
        stringBuffer.append("</msubsup>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Binomial(null, null);
    }
}

