/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Log;
import jscl.math.function.NotRootException;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;

public class Pow
extends Algebraic {
    public Pow(Generic generic, Generic generic2) {
        super("power", new Generic[]{generic, generic2});
    }

    @Override
    public Root rootValue() throws NotRootException {
        block6: {
            try {
                Variable variable = this.parameter[1].variableValue();
                if (!(variable instanceof Inv)) break block6;
                Generic generic = ((Inv)variable).parameter();
                try {
                    int n = generic.integerValue().intValue();
                    if (n > 0) {
                        Generic[] genericArray = new Generic[n + 1];
                        genericArray[0] = this.parameter[0].negate();
                        for (int i = 1; i < n; ++i) {
                            genericArray[i] = JSCLInteger.valueOf(0L);
                        }
                        genericArray[n] = JSCLInteger.valueOf(1L);
                        return new Root(genericArray, 0);
                    }
                }
                catch (NotIntegerException notIntegerException) {}
            }
            catch (NotVariableException notVariableException) {
                // empty catch block
            }
        }
        throw new NotRootException();
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        try {
            Root root = this.rootValue();
            Generic[] genericArray = root.parameters();
            if (genericArray[0].isPolynomial(variable)) {
                return Antiderivative.compute(root, variable);
            }
            throw new NotIntegrableException();
        }
        catch (NotRootException notRootException) {
            return super.antiderivative(variable);
        }
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        if (n == 0) {
            return new Pow(this.parameter[0], this.parameter[1].add(JSCLInteger.valueOf(1L))).evaluate().multiply(new Inv(this.parameter[1].add(JSCLInteger.valueOf(1L))).evaluate());
        }
        return new Pow(this.parameter[0], this.parameter[1]).evaluate().multiply(new Inv(new Log(this.parameter[0]).evaluate()).evaluate());
    }

    @Override
    public Generic derivative(int n) {
        if (n == 0) {
            return new Pow(this.parameter[0], this.parameter[1].subtract(JSCLInteger.valueOf(1L))).evaluate().multiply(this.parameter[1]);
        }
        return new Pow(this.parameter[0], this.parameter[1]).evaluate().multiply(new Log(this.parameter[0]).evaluate());
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return JSCLInteger.valueOf(1L);
        }
        if (this.parameter[1].signum() < 0) {
            return new Pow(new Inv(this.parameter[0]).evaluate(), this.parameter[1].negate()).evaluate();
        }
        try {
            int n = this.parameter[1].integerValue().intValue();
            return this.parameter[0].pow(n);
        }
        catch (NotIntegerException notIntegerException) {
            try {
                Root root = this.rootValue();
                int n = root.degree();
                Generic[] genericArray = root.parameters();
                Generic generic = genericArray[0].negate();
                try {
                    JSCLInteger jSCLInteger;
                    JSCLInteger jSCLInteger2 = generic.integerValue();
                    if (jSCLInteger2.signum() >= 0 && ((Generic)(jSCLInteger = jSCLInteger2.nthrt(n))).pow(n).compareTo(jSCLInteger2) == 0) {
                        return jSCLInteger;
                    }
                }
                catch (NotIntegerException notIntegerException2) {}
            }
            catch (NotRootException notRootException) {
                // empty catch block
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        return new Exp(new Log(this.parameter[0]).evalelem().multiply(this.parameter[1])).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return JSCLInteger.valueOf(1L);
        }
        if (this.parameter[1].signum() < 0) {
            return new Pow(new Inv(this.parameter[0]).evalsimp(), this.parameter[1].negate()).evalsimp();
        }
        try {
            int n = this.parameter[1].integerValue().intValue();
            return this.parameter[0].pow(n);
        }
        catch (NotIntegerException notIntegerException) {
            block13: {
                try {
                    Root root = this.rootValue();
                    int n = root.degree();
                    Generic[] genericArray = root.parameters();
                    Generic generic = genericArray[0].negate();
                    try {
                        JSCLInteger jSCLInteger;
                        JSCLInteger jSCLInteger2 = generic.integerValue();
                        if (jSCLInteger2.signum() >= 0 && ((Generic)(jSCLInteger = jSCLInteger2.nthrt(n))).pow(n).compareTo(jSCLInteger2) == 0) {
                            return jSCLInteger;
                        }
                    }
                    catch (NotIntegerException notIntegerException2) {
                        // empty catch block
                    }
                    switch (n) {
                        case 2: {
                            return new Sqrt(generic).evalsimp();
                        }
                        case 3: 
                        case 4: 
                        case 6: {
                            if (generic.compareTo(JSCLInteger.valueOf(-1L)) != 0) break;
                            return Pow.root_minus_1(n);
                        }
                    }
                }
                catch (NotRootException notRootException) {
                    Generic[] genericArray = Frac.separateCoefficient(this.parameter[1]);
                    if (genericArray[0].compareTo(JSCLInteger.valueOf(1L)) == 0 && genericArray[1].compareTo(JSCLInteger.valueOf(1L)) == 0) break block13;
                    return new Pow(new Pow(new Pow(this.parameter[0], genericArray[2]).evalsimp(), new Inv(genericArray[1]).evalsimp()).evalsimp(), genericArray[0]).evalsimp();
                }
            }
            return this.expressionValue();
        }
    }

    static Generic root_minus_1(int n) {
        switch (n) {
            case 1: {
                return JSCLInteger.valueOf(-1L);
            }
            case 2: {
                return Constant.i;
            }
            case 3: {
                return Constant.jbar.negate();
            }
            case 4: {
                return new Sqrt(Constant.half).expressionValue().multiply(JSCLInteger.valueOf(1L).add(Constant.i));
            }
            case 6: {
                return Constant.half.multiply(new Sqrt(JSCLInteger.valueOf(3L)).expressionValue().add(Constant.i));
            }
        }
        return null;
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).pow((Function)this.parameter[1]);
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).pow((NumericWrapper)this.parameter[1]);
    }

    @Override
    public String toString() {
        Variable variable;
        JSCLInteger jSCLInteger;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            jSCLInteger = this.parameter[0].integerValue();
            if (jSCLInteger.signum() < 0) {
                stringBuffer.append(GenericVariable.valueOf(jSCLInteger, true));
            } else {
                stringBuffer.append(jSCLInteger);
            }
        }
        catch (NotIntegerException notIntegerException) {
            try {
                variable = this.parameter[0].variableValue();
                if (variable instanceof Frac || variable instanceof Pow) {
                    stringBuffer.append(GenericVariable.valueOf(this.parameter[0]));
                } else {
                    stringBuffer.append(variable);
                }
            }
            catch (NotVariableException notVariableException) {
                try {
                    Power power = this.parameter[0].powerValue();
                    if (power.exponent() == 1) {
                        stringBuffer.append(power.value());
                    } else {
                        stringBuffer.append(GenericVariable.valueOf(this.parameter[0]));
                    }
                }
                catch (NotPowerException notPowerException) {
                    stringBuffer.append(GenericVariable.valueOf(this.parameter[0]));
                }
            }
        }
        stringBuffer.append("^");
        try {
            jSCLInteger = this.parameter[1].integerValue();
            stringBuffer.append(jSCLInteger);
        }
        catch (NotIntegerException notIntegerException) {
            try {
                variable = this.parameter[1].variableValue();
                if (variable instanceof Frac) {
                    stringBuffer.append(GenericVariable.valueOf(this.parameter[1]));
                } else {
                    stringBuffer.append(variable);
                }
            }
            catch (NotVariableException notVariableException) {
                try {
                    this.parameter[1].powerValue();
                    stringBuffer.append(this.parameter[1]);
                }
                catch (NotPowerException notPowerException) {
                    stringBuffer.append(GenericVariable.valueOf(this.parameter[1]));
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Pow(null, null);
    }
}

