/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Function;
import jscl.util.ArrayComparator;

public class ImplicitFunction
extends Function {
    protected int[] derivation;
    protected Generic[] subscript;

    public static Curried apply(String string, int[] nArray) {
        return new Curried(string, nArray, new Generic[0]);
    }

    public static Curried[] apply(String string, int[] nArray, int n) {
        Curried[] curriedArray = new Curried[n];
        for (int i = 0; i < n; ++i) {
            curriedArray[i] = new Curried(string, nArray, new Generic[]{JSCLInteger.valueOf(i)});
        }
        return curriedArray;
    }

    public ImplicitFunction(String string, Generic[] genericArray, int[] nArray, Generic[] genericArray2) {
        super(string, genericArray);
        this.derivation = nArray;
        this.subscript = genericArray2;
    }

    public ImplicitFunction(String string, Generic[] genericArray) {
        this(string, genericArray, new int[genericArray.length], new Generic[0]);
    }

    public int[] derivation() {
        return this.derivation;
    }

    public Generic[] subscript() {
        return this.subscript;
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        int[] nArray = new int[this.derivation.length];
        for (int i = 0; i < nArray.length; ++i) {
            if (i == n) {
                if (this.derivation[i] > 0) {
                    nArray[i] = this.derivation[i] - 1;
                    continue;
                }
                throw new NotIntegrableException();
            }
            nArray[i] = this.derivation[i];
        }
        return new ImplicitFunction(this.name, this.parameter, nArray, this.subscript).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        int[] nArray = new int[this.derivation.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i == n ? this.derivation[i] + 1 : this.derivation[i];
        }
        return new ImplicitFunction(this.name, this.parameter, nArray, this.subscript).evaluate();
    }

    @Override
    public Generic evaluate() {
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.expressionValue();
    }

    @Override
    public Generic evalsimp() {
        return this.expressionValue();
    }

    @Override
    public Generic evalfunc() {
        throw new ArithmeticException();
    }

    @Override
    public Generic evalnum() {
        throw new ArithmeticException();
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        ImplicitFunction implicitFunction = (ImplicitFunction)variable;
        n = this.name.compareTo(implicitFunction.name);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        n = ArrayComparator.comparator.compare(this.subscript, implicitFunction.subscript);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        n = ImplicitFunction.compareDerivation(this.derivation, implicitFunction.derivation);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return ArrayComparator.comparator.compare(this.parameter, implicitFunction.parameter);
    }

    static int compareDerivation(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = n - 1; i >= 0; --i) {
            if (nArray[i] < nArray2[i]) {
                return -1;
            }
            if (nArray[i] <= nArray2[i]) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (n = 0; n < this.derivation.length; ++n) {
            n2 += this.derivation[n];
        }
        stringBuffer.append(this.name);
        for (n = 0; n < this.subscript.length; ++n) {
            stringBuffer.append("[").append(this.subscript[n]).append("]");
        }
        if (n2 != 0) {
            if (this.parameter.length == 1 && n2 <= 3) {
                stringBuffer.append(Constant.primechars(n2));
            } else {
                stringBuffer.append(this.derivationToString());
            }
        }
        stringBuffer.append("(");
        for (n = 0; n < this.parameter.length; ++n) {
            stringBuffer.append(this.parameter[n]).append(n < this.parameter.length - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    String derivationToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.derivation.length; ++i) {
            stringBuffer.append(this.derivation[i]).append(i < this.derivation.length - 1 ? ", " : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply>");
        stringBuffer.append("<ci>" + this.bodyToMathML() + "</ci>");
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    String bodyToMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.derivation.length; ++i) {
            n += this.derivation[i];
        }
        if (this.subscript.length == 0) {
            if (n == 0) {
                stringBuffer.append(this.nameToMathML());
            } else if (this.parameter.length == 1 && n <= 3) {
                stringBuffer.append(this.nameToMathML() + Constant.primecharsToMathML(n));
            } else {
                stringBuffer.append("<msup>");
                stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
                stringBuffer.append(this.derivationToMathML(n));
                stringBuffer.append("</msup>");
            }
        } else if (n == 0) {
            stringBuffer.append("<msub>");
            stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
            stringBuffer.append(this.subscriptToMathML());
            stringBuffer.append("</msub>");
        } else if (this.parameter.length == 1 && n <= 3) {
            stringBuffer.append("<msub>");
            stringBuffer.append("<mi>" + this.nameToMathML() + Constant.primecharsToMathML(n) + "</mi>");
            stringBuffer.append(this.subscriptToMathML());
            stringBuffer.append("</msub>");
        } else {
            stringBuffer.append("<msubsup>");
            stringBuffer.append("<mi>" + this.nameToMathML() + "</mi>");
            stringBuffer.append(this.subscriptToMathML());
            stringBuffer.append(this.derivationToMathML(n));
            stringBuffer.append("</msubsup>");
        }
        return stringBuffer.toString();
    }

    String subscriptToMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<mrow>");
        for (int i = 0; i < this.subscript.length; ++i) {
            stringBuffer.append(this.subscript[i].toMathML());
        }
        stringBuffer.append("</mrow>");
        return stringBuffer.toString();
    }

    String derivationToMathML(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<mfenced>");
        for (int i = 0; i < this.derivation.length; ++i) {
            stringBuffer.append("<mn>" + String.valueOf(this.derivation[i]) + "</mn>");
        }
        stringBuffer.append("</mfenced>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new ImplicitFunction(this.name, new Generic[this.parameter.length], this.derivation, this.subscript);
    }

    public static class Curried {
        final String name;
        final int[] derivation;
        final Generic[] subscript;

        public Curried(String string, int[] nArray, Generic[] genericArray) {
            this.name = string;
            this.derivation = nArray;
            this.subscript = genericArray;
        }

        public Generic apply(Generic[] genericArray) {
            return new ImplicitFunction(this.name, genericArray, this.derivation, this.subscript).expressionValue();
        }
    }
}

