/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Expression;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.GenericVariable;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Inv;
import jscl.math.function.Root;

public class Frac
extends Algebraic {
    public Frac(Generic generic, Generic generic2) {
        super("frac", new Generic[]{generic, generic2});
    }

    @Override
    public Root rootValue() {
        return new Root(new Generic[]{this.parameter[0].negate(), this.parameter[1]}, 0);
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        if (this.parameter[0].isPolynomial(variable) && this.parameter[1].isPolynomial(variable)) {
            return Antiderivative.compute(this, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        if (n == 0) {
            return new Inv(this.parameter[1]).evaluate();
        }
        return this.parameter[0].multiply(new Inv(this.parameter[1]).evaluate().pow(2).negate());
    }

    public boolean integer() {
        try {
            this.parameter[0].integerValue().intValue();
            this.parameter[1].integerValue().intValue();
            return true;
        }
        catch (NotIntegerException notIntegerException) {
            return false;
        }
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return new Inv(this.parameter[1]).evaluate();
        }
        if (this.parameter[0].multiple(this.parameter[1])) {
            return this.parameter[0].divide(this.parameter[1]);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Frac(this.parameter[0].negate(), this.parameter[1]).evalsimp().negate();
        }
        if (this.parameter[1].signum() < 0) {
            return new Frac(this.parameter[0].negate(), this.parameter[1].negate()).evalsimp();
        }
        return this.evaluate();
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).divide((Function)this.parameter[1]);
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).divide((NumericWrapper)this.parameter[1]);
    }

    static Generic[] separateCoefficient(Generic generic) {
        if (generic.signum() < 0) {
            Generic[] genericArray = Frac.separateCoefficient(generic.negate());
            return new Generic[]{genericArray[0], genericArray[1], genericArray[2].negate()};
        }
        try {
            Variable variable = generic.variableValue();
            if (variable instanceof Frac) {
                Generic[] genericArray = ((Frac)variable).parameters();
                Expression expression = genericArray[0].expressionValue();
                Expression expression2 = genericArray[1].expressionValue();
                Generic[] genericArray2 = expression.gcdAndNormalize();
                Generic[] genericArray3 = expression2.gcdAndNormalize();
                return new Generic[]{genericArray2[0], genericArray3[0], new Frac(genericArray2[1], genericArray3[1]).evaluate()};
            }
        }
        catch (NotVariableException notVariableException) {
            try {
                Expression expression = generic.expressionValue();
                Generic[] genericArray = expression.gcdAndNormalize();
                return new Generic[]{genericArray[0], JSCLInteger.valueOf(1L), genericArray[1]};
            }
            catch (NotExpressionException notExpressionException) {
                // empty catch block
            }
        }
        return new Generic[]{JSCLInteger.valueOf(1L), JSCLInteger.valueOf(1L), generic};
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.parameter[0].powerValue();
            stringBuffer.append(this.parameter[0]);
        }
        catch (NotPowerException notPowerException) {
            stringBuffer.append(GenericVariable.valueOf(this.parameter[0]));
        }
        stringBuffer.append("/");
        try {
            Variable variable = this.parameter[1].variableValue();
            if (variable instanceof Frac) {
                stringBuffer.append(GenericVariable.valueOf(this.parameter[1]));
            } else {
                stringBuffer.append(variable);
            }
        }
        catch (NotVariableException notVariableException) {
            try {
                this.parameter[1].abs().powerValue();
                stringBuffer.append(this.parameter[1]);
            }
            catch (NotPowerException notPowerException) {
                stringBuffer.append(GenericVariable.valueOf(this.parameter[1]));
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        return "<apply><divide/>" + this.parameter[0].toMathML() + this.parameter[1].toMathML() + "</apply>";
    }

    @Override
    protected Variable newinstance() {
        return new Frac(null, null);
    }
}

