/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Inv;
import jscl.math.function.Root;

public class Cubic
extends Algebraic {
    public Cubic(Generic generic) {
        super("cubic", new Generic[]{generic});
    }

    @Override
    public Root rootValue() {
        return new Root(new Generic[]{this.parameter[0].negate(), JSCLInteger.valueOf(0L), JSCLInteger.valueOf(0L), JSCLInteger.valueOf(1L)}, 0);
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Root root = this.rootValue();
        Generic[] genericArray = root.parameters();
        if (genericArray[0].isPolynomial(variable)) {
            return Antiderivative.compute(root, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        return Constant.third.multiply(new Inv(this.evaluate().pow(2)).evaluate());
    }

    @Override
    public Generic evaluate() {
        try {
            JSCLInteger jSCLInteger;
            JSCLInteger jSCLInteger2 = this.parameter[0].integerValue();
            if (jSCLInteger2.signum() >= 0 && ((Generic)(jSCLInteger = jSCLInteger2.nthrt(3))).pow(3).compareTo(jSCLInteger2) == 0) {
                return jSCLInteger;
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        try {
            JSCLInteger jSCLInteger = this.parameter[0].integerValue();
            if (jSCLInteger.signum() < 0) {
                return new Cubic(jSCLInteger.negate()).evalsimp().negate();
            }
            JSCLInteger jSCLInteger2 = jSCLInteger.nthrt(3);
            if (((Generic)jSCLInteger2).pow(3).compareTo(jSCLInteger) == 0) {
                return jSCLInteger2;
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).nthrt(3);
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).nthrt(3);
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply><root/><degree>");
        stringBuffer.append(JSCLInteger.valueOf(3L).toMathML());
        stringBuffer.append("</degree>");
        stringBuffer.append(this.parameter[0].toMathML());
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Cubic(null);
    }
}

