/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Constraint;
import jscl.math.Debug;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.function.Cubic;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.NotRootException;
import jscl.math.function.Pow;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;

public class Simplification {
    Map cache = new TreeMap();
    Generic result;
    List constraint;
    boolean linear;

    Simplification() {
    }

    public static Generic compute(Generic generic) {
        Simplification simplification = new Simplification();
        simplification.computeValue(generic);
        return simplification.getValue();
    }

    void computeValue(Generic generic) {
        Debug.println("simplification");
        Debug.increment();
        TechnicalVariable technicalVariable = new TechnicalVariable("t");
        this.linear = false;
        this.constraint = new ArrayList();
        this.process(new Constraint(technicalVariable, technicalVariable.expressionValue().subtract(generic), false));
        UnivariatePolynomial univariatePolynomial = this.polynomial(technicalVariable);
        switch (univariatePolynomial.degree()) {
            case 0: {
                this.result = generic;
                break;
            }
            case 1: {
                this.result = new Root(univariatePolynomial, 0).evalsimp();
                break;
            }
            default: {
                this.linear(generic);
            }
        }
        Debug.decrement();
    }

    void linear(Generic generic) {
        TechnicalVariable technicalVariable = new TechnicalVariable("t");
        this.linear = true;
        this.constraint.clear();
        this.process(new Constraint(technicalVariable, technicalVariable.expressionValue().subtract(generic), false));
        UnivariatePolynomial univariatePolynomial = this.polynomial(technicalVariable);
        switch (univariatePolynomial.degree()) {
            case 0: {
                this.result = generic;
                break;
            }
            default: {
                this.result = new Root(univariatePolynomial, 0).evalsimp();
            }
        }
    }

    int branch(Generic generic, UnivariatePolynomial univariatePolynomial) {
        int n = univariatePolynomial.degree();
        TechnicalVariable technicalVariable = new TechnicalVariable("t");
        this.linear = true;
        for (int i = 0; i < n; ++i) {
            this.constraint.clear();
            this.process(new Constraint(technicalVariable, technicalVariable.expressionValue().subtract(generic.subtract(new Root(univariatePolynomial, i).expressionValue())), false));
            Generic generic2 = this.polynomial(technicalVariable).solve();
            if (generic2 == null || generic2.signum() != 0) continue;
            return i;
        }
        return n;
    }

    UnivariatePolynomial polynomial(Variable variable) {
        Polynomial polynomial = Polynomial.factory(variable);
        int n = this.constraint.size();
        Generic[] genericArray = new Generic[n];
        Variable[] variableArray = new Variable[n];
        if (this.linear) {
            Object object;
            int n2;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                Constraint constraint = (Constraint)this.constraint.get(n3);
                if (!constraint.reduce) continue;
                genericArray[n4] = constraint.generic;
                variableArray[n4] = constraint.unknown;
                ++n4;
            }
            n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                object = (Constraint)this.constraint.get(n2);
                if (((Constraint)object).reduce) continue;
                genericArray[n4] = ((Constraint)object).generic;
                variableArray[n4] = ((Constraint)object).unknown;
                ++n4;
                ++n3;
            }
            genericArray = this.solve(genericArray, variableArray, n3);
            for (n2 = 0; n2 < genericArray.length; ++n2) {
                object = (UnivariatePolynomial)polynomial.valueof(genericArray[n2]);
                if (((UnivariatePolynomial)object).degree() != 1) continue;
                return object;
            }
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Constraint constraint = (Constraint)this.constraint.get(i);
            genericArray[i] = constraint.generic;
            variableArray[i] = constraint.unknown;
        }
        genericArray = this.solve(genericArray, variableArray, n);
        return (UnivariatePolynomial)polynomial.valueof(genericArray[0]);
    }

    Generic[] solve(Generic[] genericArray, Variable[] variableArray, int n) {
        Variable[] variableArray2 = Basis.augmentUnknown(variableArray, genericArray);
        return Basis.compute(genericArray, variableArray2, Monomial.kthElimination(n)).elements();
    }

    void process(Constraint constraint) {
        int n = 0;
        int n2 = 0;
        this.constraint.add(constraint);
        do {
            n = n2;
            n2 = this.constraint.size();
            for (int i = n; i < n2; ++i) {
                constraint = (Constraint)this.constraint.get(i);
                this.subProcess(constraint);
            }
        } while (n < n2);
    }

    void subProcess(Constraint constraint) {
        Variable[] variableArray = constraint.generic.variables();
        for (int i = 0; i < variableArray.length; ++i) {
            int n;
            Object object;
            Variable variable = variableArray[i];
            if (this.constraint.contains(new Constraint(variable))) continue;
            constraint = null;
            if (variable instanceof Frac) {
                object = ((Frac)variable).parameters();
                constraint = new Constraint(variable, variable.expressionValue().multiply(object[1]).subtract(object[0]), false);
            } else if (variable instanceof Sqrt) {
                object = ((Sqrt)variable).parameters();
                if (this.linear) {
                    constraint = this.linearConstraint(variable);
                }
                if (constraint == null) {
                    constraint = new Constraint(variable, variable.expressionValue().pow(2).subtract((Generic)object[0]), true);
                }
            } else if (variable instanceof Cubic) {
                object = ((Cubic)variable).parameters();
                if (this.linear) {
                    constraint = this.linearConstraint(variable);
                }
                if (constraint == null) {
                    constraint = new Constraint(variable, variable.expressionValue().pow(3).subtract((Generic)object[0]), true);
                }
            } else if (variable instanceof Pow) {
                try {
                    object = ((Pow)variable).rootValue();
                    n = ((Root)object).degree();
                    Generic[] genericArray = ((Function)object).parameters();
                    if (this.linear) {
                        constraint = this.linearConstraint(variable);
                    }
                    if (constraint == null) {
                        constraint = new Constraint(variable, variable.expressionValue().pow(n).subtract(genericArray[0].negate()), n > 1);
                    }
                }
                catch (NotRootException notRootException) {
                    constraint = this.linearConstraint(variable);
                }
            } else if (variable instanceof Root) {
                try {
                    object = (Root)variable;
                    n = ((Root)object).degree();
                    int n2 = ((Root)object).subscript().integerValue().intValue();
                    Generic[] genericArray = ((Function)object).parameters();
                    if (this.linear) {
                        constraint = this.linearConstraint(variable);
                    }
                    if (constraint == null) {
                        constraint = new Constraint(variable, Root.sigma(genericArray, n - n2).multiply(JSCLInteger.valueOf(-1L).pow(n - n2)).multiply(genericArray[n]).subtract(genericArray[n2]), n > 1);
                    }
                }
                catch (NotIntegerException notIntegerException) {
                    constraint = this.linearConstraint(variable);
                }
            } else {
                constraint = this.linearConstraint(variable);
            }
            if (constraint == null) continue;
            this.constraint.add(constraint);
        }
    }

    Constraint linearConstraint(Variable variable) {
        Generic generic;
        Object v = this.cache.get(variable);
        if (v != null) {
            generic = (Generic)v;
        } else {
            generic = variable.simplify();
            this.cache.put(variable, generic);
        }
        Generic generic2 = variable.expressionValue().subtract(generic);
        if (generic2.signum() != 0) {
            return new Constraint(variable, generic2, false);
        }
        return null;
    }

    Generic getValue() {
        return this.result;
    }
}

