/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.math.BigInteger;
import jscl.math.Expression;
import jscl.math.Field;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Inv;

public final class Rational
extends Generic
implements Field {
    public static final Rational factory = new Rational(BigInteger.valueOf(0L), BigInteger.valueOf(1L));
    final BigInteger numerator;
    final BigInteger denominator;

    public Rational(BigInteger bigInteger, BigInteger bigInteger2) {
        this.numerator = bigInteger;
        this.denominator = bigInteger2;
    }

    public BigInteger numerator() {
        return this.numerator;
    }

    public BigInteger denominator() {
        return this.denominator;
    }

    public Rational add(Rational rational) {
        BigInteger bigInteger = this.denominator.gcd(rational.denominator);
        BigInteger bigInteger2 = this.denominator.divide(bigInteger);
        BigInteger bigInteger3 = rational.denominator.divide(bigInteger);
        return new Rational(this.numerator.multiply(bigInteger3).add(rational.numerator.multiply(bigInteger2)), this.denominator.multiply(bigInteger3)).reduce();
    }

    Rational reduce() {
        BigInteger bigInteger = this.numerator.gcd(this.denominator);
        if (bigInteger.signum() != this.denominator.signum()) {
            bigInteger = bigInteger.negate();
        }
        return bigInteger.signum() == 0 ? this : new Rational(this.numerator.divide(bigInteger), this.denominator.divide(bigInteger));
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof Rational) {
            return this.add((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.add(this.valueof(generic));
        }
        return generic.valueof(this).add(generic);
    }

    public Rational multiply(Rational rational) {
        BigInteger bigInteger = this.numerator.gcd(rational.denominator);
        BigInteger bigInteger2 = this.denominator.gcd(rational.numerator);
        return new Rational(this.numerator.divide(bigInteger).multiply(rational.numerator.divide(bigInteger2)), this.denominator.divide(bigInteger2).multiply(rational.denominator.divide(bigInteger)));
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof Rational) {
            return this.multiply((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.multiply(this.valueof(generic));
        }
        return generic.multiply(this);
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof Rational) {
            return this.multiply(generic.inverse());
        }
        if (generic instanceof JSCLInteger) {
            return this.divide(this.valueof(generic));
        }
        return generic.valueof(this).divide(generic);
    }

    @Override
    public Generic inverse() {
        if (this.signum() < 0) {
            return new Rational(this.denominator.negate(), this.numerator.negate());
        }
        return new Rational(this.denominator, this.numerator);
    }

    public Rational gcd(Rational rational) {
        return new Rational(this.numerator.gcd(rational.numerator), Rational.scm(this.denominator, rational.denominator));
    }

    @Override
    public Generic gcd(Generic generic) {
        if (generic instanceof Rational) {
            return this.gcd((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.gcd(this.valueof(generic));
        }
        return generic.valueof(this).gcd(generic);
    }

    static BigInteger scm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.multiply(bigInteger2).divide(bigInteger.gcd(bigInteger2));
    }

    @Override
    public Generic gcd() {
        return Rational.valueOf(this.signum(), 1L);
    }

    @Override
    public Generic pow(int n) {
        Generic generic = n < 0 ? this.inverse().pow(-n) : super.pow(n);
        return generic;
    }

    @Override
    public Generic negate() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    @Override
    public int signum() {
        return this.numerator.signum();
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return this.multiply(variable.expressionValue());
    }

    @Override
    public Generic derivative(Variable variable) {
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        return this;
    }

    @Override
    public Generic expand() {
        return this;
    }

    @Override
    public Generic factorize() {
        return this.expressionValue().factorize();
    }

    @Override
    public Generic elementary() {
        return this;
    }

    @Override
    public Generic simplify() {
        return this.reduce();
    }

    @Override
    public Generic function(Variable variable) {
        return Function.valueOf(this);
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof Rational) {
            Rational rational = (Rational)generic;
            return new Rational(rational.numerator, rational.denominator);
        }
        if (generic instanceof Expression) {
            boolean bl = generic.signum() < 0;
            Generic[] genericArray = ((Frac)(bl ? generic.negate() : generic).variableValue()).parameters();
            JSCLInteger jSCLInteger = (JSCLInteger)(bl ? genericArray[0].negate() : genericArray[0]);
            JSCLInteger jSCLInteger2 = (JSCLInteger)genericArray[1];
            return new Rational(jSCLInteger.content(), jSCLInteger2.content());
        }
        JSCLInteger jSCLInteger = (JSCLInteger)generic;
        return new Rational(jSCLInteger.content(), BigInteger.valueOf(1L));
    }

    @Override
    public Generic[] sumValue() {
        try {
            if (this.integerValue().signum() == 0) {
                return new Generic[0];
            }
            return new Generic[]{this};
        }
        catch (NotIntegerException notIntegerException) {
            return new Generic[]{this};
        }
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        try {
            if (this.integerValue().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return new Generic[0];
            }
            return new Generic[]{this};
        }
        catch (NotIntegerException notIntegerException) {
            return new Generic[]{this};
        }
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return new Power(this, 1);
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        return Expression.valueOf(this);
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        if (this.denominator.compareTo(BigInteger.valueOf(1L)) == 0) {
            return new JSCLInteger(this.numerator);
        }
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        try {
            this.integerValue();
            throw new NotVariableException();
        }
        catch (NotIntegerException notIntegerException) {
            if (this.numerator.compareTo(BigInteger.valueOf(1L)) == 0) {
                return new Inv(new JSCLInteger(this.denominator));
            }
            return new Frac(new JSCLInteger(this.numerator), new JSCLInteger(this.denominator));
        }
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return true;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return true;
    }

    public int compareTo(Rational rational) {
        int n = this.denominator.compareTo(rational.denominator);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return this.numerator.compareTo(rational.numerator);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof Rational) {
            return this.compareTo((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.compareTo(this.valueof(generic));
        }
        return generic.valueof(this).compareTo(generic);
    }

    public static Rational valueOf(long l, long l2) {
        return new Rational(BigInteger.valueOf(l), BigInteger.valueOf(l2));
    }

    public static Rational valueOf(String string, String string2) {
        return new Rational(new BigInteger(string), new BigInteger(string2));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.integerValue());
        }
        catch (NotIntegerException notIntegerException) {
            stringBuffer.append(this.numerator);
            stringBuffer.append("/");
            stringBuffer.append(this.denominator);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        return "<cn type=\"rational\">" + this.numerator + "<sep/>" + this.denominator + "</cn>";
    }
}

