/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.math.BigInteger;
import jscl.math.Field;
import jscl.math.Generic;
import jscl.math.JSCLInteger;

public class ModularInteger
extends JSCLInteger
implements Field {
    private final BigInteger modulo;

    public ModularInteger(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger.mod(bigInteger2));
        this.modulo = bigInteger2;
    }

    public JSCLInteger divide(ModularInteger modularInteger) {
        return this.multiply(modularInteger.inverse());
    }

    @Override
    public JSCLInteger integerDivide(JSCLInteger jSCLInteger) {
        return this.divide(this.valueof(jSCLInteger));
    }

    @Override
    public ModularInteger inverse() {
        return this.newinstance(this.content.modInverse(this.modulo));
    }

    public ModularInteger gcd(ModularInteger modularInteger) {
        return modularInteger.signum() == 0 ? this : modularInteger;
    }

    @Override
    public ModularInteger gcd(JSCLInteger jSCLInteger) {
        return this.gcd(this.valueof(jSCLInteger));
    }

    @Override
    public ModularInteger pow(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.modPow(jSCLInteger.content(), this.modulo));
    }

    @Override
    public ModularInteger negate() {
        return this.newinstance(this.modulo.subtract(this.content));
    }

    @Override
    public ModularInteger valueof(Generic generic) {
        return (ModularInteger)super.valueof(generic);
    }

    public static ModularInteger valueOf(String string, String string2) {
        return new ModularInteger(new BigInteger(string), new BigInteger(string2));
    }

    @Override
    public String toString() {
        return this.content.toString();
    }

    @Override
    public String toMathML() {
        return "<cn type=\"integer\" base=\"" + this.modulo + "\">" + this.content + "</cn>";
    }

    @Override
    protected ModularInteger newinstance(BigInteger bigInteger) {
        return new ModularInteger(bigInteger, this.modulo);
    }
}

