/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.math.BigInteger;
import jscl.math.Expression;
import jscl.math.Factorization;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.NotDivisibleException;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Rational;
import jscl.math.Variable;

public class JSCLInteger
extends Generic {
    public static final JSCLInteger factory = new JSCLInteger(BigInteger.valueOf(0L));
    final BigInteger content;
    private static final JSCLInteger ZERO = new JSCLInteger(BigInteger.valueOf(0L));
    private static final JSCLInteger ONE = new JSCLInteger(BigInteger.valueOf(1L));

    public JSCLInteger(BigInteger bigInteger) {
        this.content = bigInteger;
    }

    public BigInteger content() {
        return this.content;
    }

    public JSCLInteger add(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.add(jSCLInteger.content));
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof JSCLInteger) {
            return this.add((JSCLInteger)generic);
        }
        return generic.valueof(this).add(generic);
    }

    public JSCLInteger subtract(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.subtract(jSCLInteger.content));
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof JSCLInteger) {
            return this.subtract((JSCLInteger)generic);
        }
        return generic.valueof(this).subtract(generic);
    }

    public JSCLInteger multiply(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.multiply(jSCLInteger.content));
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof JSCLInteger) {
            return this.multiply((JSCLInteger)generic);
        }
        return generic.multiply(this);
    }

    @Override
    public boolean multiple(Generic generic) throws ArithmeticException {
        return this.remainder(generic).signum() == 0;
    }

    public JSCLInteger integerDivide(JSCLInteger jSCLInteger) throws ArithmeticException {
        JSCLInteger[] jSCLIntegerArray = this.divideAndRemainder(jSCLInteger);
        if (jSCLIntegerArray[1].signum() == 0) {
            return jSCLIntegerArray[0];
        }
        throw new NotDivisibleException();
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof JSCLInteger) {
            JSCLInteger jSCLInteger = (JSCLInteger)generic;
            if (this.multiple(jSCLInteger)) {
                return this.integerDivide(jSCLInteger);
            }
            return new Rational(this.content(), jSCLInteger.content());
        }
        return generic.valueof(this).divide(generic);
    }

    public JSCLInteger[] divideAndRemainder(JSCLInteger jSCLInteger) throws ArithmeticException {
        BigInteger[] bigIntegerArray = this.content.divideAndRemainder(jSCLInteger.content);
        return new JSCLInteger[]{this.newinstance(bigIntegerArray[0]), this.newinstance(bigIntegerArray[1])};
    }

    @Override
    public Generic[] divideAndRemainder(Generic generic) throws ArithmeticException {
        if (generic instanceof JSCLInteger) {
            return this.divideAndRemainder((JSCLInteger)generic);
        }
        return generic.valueof(this).divideAndRemainder(generic);
    }

    public JSCLInteger remainder(JSCLInteger jSCLInteger) throws ArithmeticException {
        return this.newinstance(this.content.remainder(jSCLInteger.content));
    }

    @Override
    public Generic remainder(Generic generic) throws ArithmeticException {
        if (generic instanceof JSCLInteger) {
            return this.remainder((JSCLInteger)generic);
        }
        return generic.valueof(this).remainder(generic);
    }

    public JSCLInteger gcd(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.gcd(jSCLInteger.content));
    }

    @Override
    public Generic gcd(Generic generic) {
        if (generic instanceof JSCLInteger) {
            return this.gcd((JSCLInteger)generic);
        }
        return generic.valueof(this).gcd(generic);
    }

    @Override
    public JSCLInteger gcd() {
        return JSCLInteger.valueOf(this.signum());
    }

    @Override
    public JSCLInteger pow(int n) {
        return this.newinstance(this.content.pow(n));
    }

    @Override
    public JSCLInteger negate() {
        return this.newinstance(this.content.negate());
    }

    @Override
    public int signum() {
        return this.content.signum();
    }

    @Override
    public int degree() {
        return 0;
    }

    public JSCLInteger factorial() {
        return this.factorial(1);
    }

    public JSCLInteger factorial(int n) {
        int n2 = this.intValue();
        JSCLInteger jSCLInteger = JSCLInteger.valueOf(1L);
        for (int i = n2; i > 1; i -= n) {
            jSCLInteger = jSCLInteger.multiply(JSCLInteger.valueOf(i));
        }
        return jSCLInteger;
    }

    public JSCLInteger mod(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.mod(jSCLInteger.content));
    }

    public JSCLInteger modPow(JSCLInteger jSCLInteger, JSCLInteger jSCLInteger2) {
        return this.newinstance(this.content.modPow(jSCLInteger.content, jSCLInteger2.content));
    }

    public JSCLInteger modInverse(JSCLInteger jSCLInteger) {
        return this.newinstance(this.content.modInverse(jSCLInteger.content));
    }

    public JSCLInteger phi() {
        if (this.signum() == 0) {
            return this;
        }
        Generic generic = this.factorize();
        Generic[] genericArray = generic.productValue();
        Generic generic2 = JSCLInteger.valueOf(1L);
        for (int i = 0; i < genericArray.length; ++i) {
            Power power = genericArray[i].powerValue();
            Generic generic3 = power.value();
            int n = power.exponent();
            generic2 = ((Generic)generic2).multiply(generic3.subtract(JSCLInteger.valueOf(1L)).multiply(generic3.pow(n - 1)));
        }
        return ((Generic)generic2).integerValue();
    }

    public JSCLInteger[] primitiveRoots() {
        int n;
        JSCLInteger jSCLInteger = this.phi();
        Generic generic = jSCLInteger.factorize();
        Generic[] genericArray = generic.productValue();
        JSCLInteger[] jSCLIntegerArray = new JSCLInteger[genericArray.length];
        for (n = 0; n < genericArray.length; ++n) {
            jSCLIntegerArray[n] = jSCLInteger.integerDivide(genericArray[n].powerValue().value().integerValue());
        }
        n = 0;
        JSCLInteger jSCLInteger2 = this;
        JSCLInteger jSCLInteger3 = JSCLInteger.valueOf(1L);
        JSCLInteger[] jSCLIntegerArray2 = new JSCLInteger[jSCLInteger.phi().intValue()];
        while (jSCLInteger3.compareTo(jSCLInteger2) < 0) {
            boolean bl = jSCLInteger3.gcd(jSCLInteger2).compareTo(JSCLInteger.valueOf(1L)) == 0;
            for (int i = 0; i < jSCLIntegerArray.length; ++i) {
                bl = bl && jSCLInteger3.modPow(jSCLIntegerArray[i], jSCLInteger2).compareTo(JSCLInteger.valueOf(1L)) > 0;
            }
            if (bl) {
                jSCLIntegerArray2[n++] = jSCLInteger3;
            }
            jSCLInteger3 = jSCLInteger3.add(JSCLInteger.valueOf(1L));
        }
        return n > 0 ? jSCLIntegerArray2 : new JSCLInteger[]{};
    }

    public JSCLInteger sqrt() {
        return this.nthrt(2);
    }

    public JSCLInteger nthrt(int n) {
        JSCLInteger jSCLInteger;
        if (this.signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.signum() < 0) {
            if (n % 2 == 0) {
                throw new ArithmeticException();
            }
            return this.negate().nthrt(n).negate();
        }
        Generic generic = this;
        do {
            jSCLInteger = generic;
        } while ((generic = this.divideAndRemainder(generic.pow(n - 1))[0].add(generic.multiply(JSCLInteger.valueOf(n - 1))).divideAndRemainder(JSCLInteger.valueOf(n))[0]).compareTo(jSCLInteger) < 0);
        return ((Generic)jSCLInteger).integerValue();
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return this.multiply(variable.expressionValue());
    }

    @Override
    public Generic derivative(Variable variable) {
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        return this;
    }

    @Override
    public Generic expand() {
        return this;
    }

    @Override
    public Generic factorize() {
        return Factorization.compute(this);
    }

    @Override
    public Generic elementary() {
        return this;
    }

    @Override
    public Generic simplify() {
        return this;
    }

    @Override
    public Generic function(Variable variable) {
        return Function.valueOf(this);
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public JSCLInteger valueof(Generic generic) {
        return this.newinstance(((JSCLInteger)generic).content);
    }

    @Override
    public Generic[] sumValue() {
        if (this.content.signum() == 0) {
            return new Generic[0];
        }
        return new Generic[]{this};
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        if (this.content.compareTo(BigInteger.valueOf(1L)) == 0) {
            return new Generic[0];
        }
        return new Generic[]{this};
    }

    @Override
    public Power powerValue() throws NotPowerException {
        if (this.content.signum() < 0) {
            throw new NotPowerException();
        }
        return new Power(this, 1);
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        return Expression.valueOf(this);
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        return this;
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return true;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return true;
    }

    public int intValue() {
        return this.content.intValue();
    }

    public int compareTo(JSCLInteger jSCLInteger) {
        return this.content.compareTo(jSCLInteger.content);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof JSCLInteger) {
            return this.compareTo((JSCLInteger)generic);
        }
        return generic.valueof(this).compareTo(generic);
    }

    public static JSCLInteger valueOf(long l) {
        switch ((int)l) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
        }
        return new JSCLInteger(BigInteger.valueOf(l));
    }

    public static JSCLInteger valueOf(String string) {
        return new JSCLInteger(new BigInteger(string));
    }

    public String toString() {
        return this.content.toString();
    }

    @Override
    public String toMathML() {
        return "<cn>" + this.content + "</cn>";
    }

    protected JSCLInteger newinstance(BigInteger bigInteger) {
        return new JSCLInteger(bigInteger);
    }
}

