/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.io.Serializable;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Rational;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;

public abstract class Function
extends Generic
implements Serializable {
    public static final Function identity = new Function(){

        @Override
        public double apply(double d) {
            return d;
        }
    };

    public static Function valueOf(final double d) {
        return new Function(){

            @Override
            public double apply(double d2) {
                return d;
            }
        };
    }

    public static Function valueOf(JSCLInteger jSCLInteger) {
        return Function.valueOf(jSCLInteger.content().doubleValue());
    }

    public static Function valueOf(Rational rational) {
        return Function.valueOf(rational.numerator().doubleValue() / rational.denominator().doubleValue());
    }

    public abstract double apply(double var1);

    public Function add(final Function function) {
        return new Function(){

            @Override
            public double apply(double d) {
                return Function.this.apply(d) + function.apply(d);
            }
        };
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof Function) {
            return this.add((Function)generic);
        }
        return this.add(this.valueof(generic));
    }

    public Function subtract(final Function function) {
        return new Function(){

            @Override
            public double apply(double d) {
                return Function.this.apply(d) - function.apply(d);
            }
        };
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof Function) {
            return this.subtract((Function)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public Function multiply(final Function function) {
        return new Function(){

            @Override
            public double apply(double d) {
                return Function.this.apply(d) * function.apply(d);
            }
        };
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof Function) {
            return this.multiply((Function)generic);
        }
        return this.multiply(this.valueof(generic));
    }

    public Function divide(final Function function) {
        return new Function(){

            @Override
            public double apply(double d) {
                return Function.this.apply(d) / function.apply(d);
            }
        };
    }

    @Override
    public Generic divide(Generic generic) {
        if (generic instanceof Function) {
            return this.divide((Function)generic);
        }
        return this.divide(this.valueof(generic));
    }

    @Override
    public Generic gcd(Generic generic) {
        return null;
    }

    @Override
    public Generic gcd() {
        return null;
    }

    @Override
    public Function pow(int n) {
        return (Function)super.pow(n);
    }

    @Override
    public Generic abs() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.abs(Function.this.apply(d));
            }
        };
    }

    @Override
    public Function negate() {
        return new Function(){

            @Override
            public double apply(double d) {
                return -Function.this.apply(d);
            }
        };
    }

    @Override
    public int signum() {
        return 0;
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        return null;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        return null;
    }

    @Override
    public Generic expand() {
        return this;
    }

    @Override
    public Generic factorize() {
        return this;
    }

    @Override
    public Generic elementary() {
        return this;
    }

    @Override
    public Generic simplify() {
        return this;
    }

    @Override
    public Generic function(Variable variable) {
        return this;
    }

    @Override
    public Generic numeric() {
        return null;
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof Function) {
            return generic;
        }
        return generic.function(new TechnicalVariable("t"));
    }

    @Override
    public Generic[] sumValue() {
        return null;
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        return null;
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return null;
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return true;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return true;
    }

    public Generic log() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.log(Function.this.apply(d));
            }
        };
    }

    public Generic exp() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.exp(Function.this.apply(d));
            }
        };
    }

    public Function pow(final Function function) {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.pow(Function.this.apply(d), function.apply(d));
            }
        };
    }

    public Generic pow(Generic generic) {
        if (generic instanceof Function) {
            return this.pow((Function)generic);
        }
        throw new ArithmeticException();
    }

    public Function sqrt() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.sqrt(Function.this.apply(d));
            }
        };
    }

    public Generic nthrt(int n) {
        return this.pow(Function.valueOf(1.0 / (double)n));
    }

    public static Generic root(int n, Generic[] genericArray) {
        throw new ArithmeticException();
    }

    public Generic conjugate() {
        return this;
    }

    public Generic acos() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.acos(Function.this.apply(d));
            }
        };
    }

    public Generic asin() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.asin(Function.this.apply(d));
            }
        };
    }

    public Generic atan() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.atan(Function.this.apply(d));
            }
        };
    }

    public Generic acot() {
        return Function.valueOf(1.5707963267948966).subtract(this.atan());
    }

    public Generic cos() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.cos(Function.this.apply(d));
            }
        };
    }

    public Generic sin() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.sin(Function.this.apply(d));
            }
        };
    }

    public Generic tan() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.tan(Function.this.apply(d));
            }
        };
    }

    public Generic cot() {
        return this.tan().inverse();
    }

    public Generic acosh() {
        return this.add(Function.valueOf(-1.0).add(this.pow(2)).sqrt()).log();
    }

    public Generic asinh() {
        return this.add(Function.valueOf(1.0).add(this.pow(2)).sqrt()).log();
    }

    public Generic atanh() {
        return Function.valueOf(1.0).add(this).divide(Function.valueOf(1.0).subtract(this)).log().divide(Function.valueOf(2.0));
    }

    public Generic acoth() {
        return Function.valueOf(1.0).add(this).divide(Function.valueOf(1.0).subtract(this)).negate().log().divide(Function.valueOf(2.0));
    }

    public Generic cosh() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.cosh(Function.this.apply(d));
            }
        };
    }

    public Generic sinh() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.sinh(Function.this.apply(d));
            }
        };
    }

    public Generic tanh() {
        return new Function(){

            @Override
            public double apply(double d) {
                return Math.tanh(Function.this.apply(d));
            }
        };
    }

    public Generic coth() {
        return Function.valueOf(1.0).add(this.exp().pow(2)).divide(Function.valueOf(1.0).subtract(this.exp().pow(2))).negate();
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    public int compareTo(Function function) {
        return 0;
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof Function) {
            return this.compareTo((Function)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public String toString() {
        return "<function>";
    }

    @Override
    public String toMathML() {
        return "<ci>function</ci>";
    }

    protected Generic newinstance() {
        return null;
    }
}

