/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.jfacets.web.WebFacets;
import net.sourceforge.jfacets.web.WebObjectsHolder;

public class WebFacetsFilterBean
implements Filter {
    public static final String KEY_REQ_WEBFACETS = "webFacets";
    private WebObjectsHolder webObjectsHolder;
    private FilterConfig config;
    private WebFacets webFacets;

    public WebFacetsFilterBean(WebObjectsHolder woh, WebFacets wf) {
        this.webFacets = wf;
        this.webObjectsHolder = woh;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.webObjectsHolder == null) {
            throw new ServletException("Unable to prepare the WebFacets bean for the request ! The webObjectsHolder bean has not been set : check your Spring config file to see how webObjectsHolder is defined !");
        }
        if (this.webFacets == null) {
            throw new ServletException("Unable to prepare the WebFacets bean for the request ! The webFacets bean has not been set : check your Spring config file to see how webFacets is defined !");
        }
        this.webObjectsHolder.setRequest((HttpServletRequest)request);
        this.webObjectsHolder.setResponse((HttpServletResponse)response);
        this.webObjectsHolder.setServletContext(this.config.getServletContext());
        request.setAttribute(KEY_REQ_WEBFACETS, (Object)this.webFacets);
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
    }
}

