/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.sourceforge.jfacets.log.JFacetsLogger;
import net.sourceforge.jfacets.web.WebFacetsFilterBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebFacetsFilter
implements Filter {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(WebFacetsFilter.class);
    private String appCtxName = "webFacetsAppCtx.xml";
    private ApplicationContext applicationContext;
    private FilterConfig config;

    public void init(FilterConfig config) throws ServletException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Initializing WebFacetsFilter...");
        }
        this.config = config;
        String ctxName = config.getInitParameter("appCtxName");
        if (ctxName != null) {
            this.appCtxName = ctxName;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating bean factory from CLASSPATH resource '" + this.appCtxName + "'..."));
            }
            this.applicationContext = new ClassPathXmlApplicationContext(new String[]{this.appCtxName});
            if (this.applicationContext == null) {
                String msg = "Unable to find '" + this.appCtxName + "' context (as specified in the WebFacetsFilter configuration in web.xml) from the CLASSPATH !";
                this.initError(msg);
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Spring context '" + this.appCtxName + "' loaded from CLASSPATH"));
            }
        } else {
            this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
            if (this.applicationContext != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"ContextLoader-loaded Spring context obtained OK");
                }
            } else {
                this.applicationContext = new ClassPathXmlApplicationContext(new String[]{this.appCtxName});
                if (this.applicationContext == null) {
                    String msg = "Unable to find default '" + this.appCtxName + "' context, context loader not used, and no context name supplied in web.xml !";
                    this.initError(msg);
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)("Default Spring context '" + this.appCtxName + "' loaded from CLASSPATH (no context loader is used, and no context name provided in web.xml)"));
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"... filter init OK");
        }
    }

    private void initError(String msg) throws ServletException {
        logger.fatal((Object)msg);
        throw new ServletException(msg);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"doFilter() : handling request...");
        }
        WebFacetsFilterBean filterBean = (WebFacetsFilterBean)this.applicationContext.getBean("webFacetsFilterBean");
        filterBean.init(this.config);
        filterBean.doFilter(request, response, chain);
    }

    public void destroy() {
    }
}

