/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.File;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetFactory;
import net.sourceforge.jfacets.groovy.GroovyFacetDescriptor;
import net.sourceforge.jfacets.log.JFacetsLogger;

public class GroovyFacetFactory
implements IFacetFactory {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(GroovyFacetFactory.class);
    private static GroovyClassLoader groovyClassLoader;
    private IFacetFactory fallbackFactory;

    private GroovyClassLoader getGroovyClassLoader() {
        if (groovyClassLoader == null) {
            groovyClassLoader = new GroovyClassLoader();
        }
        return groovyClassLoader;
    }

    public Object createFacet(FacetDescriptor d) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("about to create facet for descriptor " + d));
        }
        if (d instanceof GroovyFacetDescriptor) {
            Object res;
            GroovyFacetDescriptor gfd = (GroovyFacetDescriptor)d;
            File scriptFile = gfd.getScriptFile();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to parse groovy class from file " + scriptFile.getAbsolutePath()));
            }
            if ((res = this.parseFacetClass(scriptFile)) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Facet found and created from IFacet class in file " + scriptFile.getAbsolutePath() + ", returning " + res));
                }
            } else {
                logger.error((Object)("file does not contain a valid class def : " + scriptFile.getAbsolutePath() + ", returning null !"));
            }
            return res;
        }
        if (this.fallbackFactory == null) {
            logger.error((Object)("Received descriptor is not a Groovy one (" + d + "), and we have " + "no fallback factory. Returning null !"));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received descriptor isn't a valid Groovy one : " + d + ", try the fallback factory..."));
        }
        Object res = this.fallbackFactory.createFacet(d);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Facet created using fallback factory, returning " + res));
        }
        return res;
    }

    private Object parseFacetClass(File facetFile) {
        Object res = null;
        try {
            Class groovyClass;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Trying to parse groovy class from file " + facetFile.getAbsolutePath() + "..."));
            }
            if ((groovyClass = this.getGroovyClassLoader().parseClass(facetFile)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Class parsed is null, return null");
                }
            } else {
                if (Script.class.isAssignableFrom(groovyClass)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Groovy Class loaded OK : " + groovyClass + ",  it's a plain script, returning null"));
                    }
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Groovy Class loaded OK : " + groovyClass + ", checking if it's a facet..."));
                }
                res = groovyClass.newInstance();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Groovy facet created, returning " + res));
                }
            }
        }
        catch (Exception e) {
            String message = "error while parsing or instanciating the facet in file " + facetFile.getAbsolutePath();
            logger.error((Object)message, (Throwable)e);
        }
        return res;
    }

    public IFacetFactory getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setFallbackFactory(IFacetFactory fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }
}

