/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.groovy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetDescriptorManager;
import net.sourceforge.jfacets.groovy.GroovyFacetDescriptor;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyFacetDescriptorManager
implements IFacetDescriptorManager,
ApplicationContextAware {
    private static final String SEPARATOR = "/";
    private static final String FACET_SCRIPT_SUFFIX1 = ".facet";
    private static final String FACET_SCRIPT_SUFFIX2 = ".groovy";
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(GroovyFacetDescriptorManager.class);
    private List<String> basePackages;
    private ApplicationContext springContext;
    private ArrayList<FacetDescriptor> descriptors = new ArrayList();

    public GroovyFacetDescriptorManager(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.springContext = ctx;
    }

    public void initialize() {
        int nbDesc = 0;
        for (String pkgBase : this.basePackages) {
            Resource[] facetFiles;
            pkgBase = SEPARATOR + pkgBase.replace('.', '/');
            try {
                String query1 = "classpath*:" + pkgBase + "/**/*" + FACET_SCRIPT_SUFFIX1;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Scanning CLASSPATH entries : " + query1));
                }
                Resource[] resources1 = this.springContext.getResources(query1);
                String query2 = "classpath*:" + pkgBase + "/**/*" + FACET_SCRIPT_SUFFIX2;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Scanning CLASSPATH entries : " + query2));
                }
                Resource[] resources2 = this.springContext.getResources(query2);
                ArrayList<Resource> resources = new ArrayList<Resource>();
                resources.addAll(Arrays.asList(resources1));
                resources.addAll(Arrays.asList(resources2));
                facetFiles = new Resource[resources.size()];
                facetFiles = resources.toArray(facetFiles);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found " + facetFiles.length + " candidates, iterating and creating descriptors..."));
                }
            }
            catch (IOException e) {
                String message = "Unable to lookup for resources using Spring Context !";
                logger.error((Object)message, (Throwable)e);
                throw new RuntimeException(message, e);
            }
            for (int i = 0; i < facetFiles.length; ++i) {
                File f;
                try {
                    f = facetFiles[i].getFile();
                }
                catch (IOException e) {
                    String message = "IOException caught while trying to access facet file '" + facetFiles[i] + "', facet file skipped";
                    logger.error((Object)message, (Throwable)e);
                    throw new RuntimeException(message, e);
                }
                String fullPath = f.getAbsolutePath();
                String name = f.getName();
                if (name != null) {
                    File typeFolder;
                    int dotIndx = name.lastIndexOf(46);
                    if (dotIndx != -1) {
                        name = name.substring(0, dotIndx);
                    }
                    if ((typeFolder = f.getParentFile()) != null) {
                        Class<?> targetObjectClass;
                        String fqcn = typeFolder.getName();
                        try {
                            targetObjectClass = Class.forName(fqcn);
                        }
                        catch (Exception ex) {
                            targetObjectClass = null;
                            logger.warn((Object)("Exception caught while trying to load target type class in facet file '" + fullPath + "'"), (Throwable)ex);
                        }
                        if (targetObjectClass != null) {
                            File pflFolder = typeFolder.getParentFile();
                            if (pflFolder != null) {
                                String profileId = pflFolder.getName();
                                GroovyFacetDescriptor d = new GroovyFacetDescriptor();
                                d.setName(name);
                                d.setProfileId(profileId);
                                d.setTargetObjectType(targetObjectClass);
                                d.setScriptFile(f);
                                this.descriptors.add(d);
                                ++nbDesc;
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("Groovy facet descriptor found and added for name='" + name + "', profileId='" + profileId + "' and targetObjectType='" + targetObjectClass + "'"));
                                continue;
                            }
                            logger.warn((Object)("Facet from file " + fullPath + " isn't defined in a parent folder, which is required (profile ID) - facet file skipped"));
                            continue;
                        }
                        logger.warn((Object)("Unable to load class target object class '" + fqcn + "' for facet from file '" + fullPath + "' - facet file skipped !"));
                        continue;
                    }
                    logger.warn((Object)("Facet from file " + fullPath + " isn't defined in a parent folder, which is required (target type) - facet file skipped"));
                    continue;
                }
                logger.warn((Object)("Unable to read facet name from file " + fullPath + ", facet file skipped"));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("init OK, " + nbDesc + " descriptors loaded"));
        }
    }

    public String computeScriptPath(String name, String profileId, Class targetObjectType) {
        StringBuffer res = new StringBuffer();
        res.append(SEPARATOR);
        res.append(profileId);
        res.append(SEPARATOR);
        res.append(targetObjectType.getSimpleName());
        res.append(SEPARATOR);
        res.append(name);
        return res.toString();
    }

    public InputStream getStreamToScript(FacetDescriptor d) {
        String path = this.computeScriptPath(d.getName(), d.getProfileId(), d.getTargetObjectType());
        InputStream res = this.getClass().getResourceAsStream(path);
        return res;
    }

    public FacetDescriptor getDescriptor(String name, String profileId, Class targetObjectType) {
        FacetDescriptor res = null;
        for (FacetDescriptor d : this.descriptors) {
            if (!d.getName().equals(name) || !d.getProfileId().equals(profileId) || !d.getTargetObjectType().equals(targetObjectType)) continue;
            res = d;
            break;
        }
        return res;
    }

    public FacetDescriptor[] getDescriptors() {
        FacetDescriptor[] res = new FacetDescriptor[this.descriptors.size()];
        res = this.descriptors.toArray(res);
        return res;
    }
}

