/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyFacetDescriptor
extends FacetDescriptor {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(GroovyFacetDescriptor.class);
    private static GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
    private Class facetClass;
    private File scriptFile;

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public Class getFacetClass() {
        if (this.facetClass == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Class not yet parsed, parsing from file " + this.scriptFile.getAbsolutePath() + ", I am " + (Object)((Object)this)));
            }
            try {
                this.facetClass = groovyClassLoader.parseClass(this.scriptFile);
            }
            catch (CompilationFailedException e) {
                logger.warn((Object)("Compilation failed, file=" + this.scriptFile.getAbsolutePath() + ", I am " + (Object)((Object)this)), (Throwable)e);
            }
            catch (IOException e) {
                logger.warn((Object)("Caught an IOException while compiling from file " + this.scriptFile.getAbsolutePath()));
            }
        }
        return this.facetClass;
    }

    public String toString() {
        return "{GroovyFacetDescriptor name=" + this.getName() + ", profileId=" + this.getProfileId() + ", targetObjectType=" + this.getTargetObjectType() + ", scriptFile=" + this.scriptFile.getAbsolutePath() + "]";
    }
}

