/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetDescriptorManager;
import net.sourceforge.jfacets.log.JFacetsLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaFacetDescriptorManager
implements IFacetDescriptorManager {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(MetaFacetDescriptorManager.class);
    private List<IFacetDescriptorManager> managers;

    protected List<FacetDescriptor> concatAll() {
        ArrayList<FacetDescriptor> res = new ArrayList<FacetDescriptor>();
        for (IFacetDescriptorManager m : this.managers) {
            res.addAll(Arrays.asList(m.getDescriptors()));
        }
        return res;
    }

    @Override
    public FacetDescriptor getDescriptor(String name, String profileId, Class targetObjectType) {
        IFacetDescriptorManager m;
        FacetDescriptor res = null;
        Iterator<IFacetDescriptorManager> i$ = this.managers.iterator();
        while (i$.hasNext() && (res = (m = i$.next()).getDescriptor(name, profileId, targetObjectType)) == null) {
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getDescriptor(" + name + "," + profileId + "," + targetObjectType + ") : returning " + res);
        }
        return res;
    }

    @Override
    public FacetDescriptor[] getDescriptors() {
        List<FacetDescriptor> all = this.concatAll();
        FacetDescriptor[] res = new FacetDescriptor[all.size()];
        res = all.toArray(res);
        if (logger.isDebugEnabled()) {
            logger.debug("getDescriptors() : returning " + res.length + " descriptor(s)");
        }
        return res;
    }

    public List<IFacetDescriptorManager> getManagers() {
        return this.managers;
    }

    public void setManagers(List<IFacetDescriptorManager> managers) {
        this.managers = managers;
    }
}

