/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FacetsSaxParser
extends DefaultHandler {
    private Vector descriptors = new Vector();
    private int nbSkipped = 0;
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(FacetsSaxParser.class);

    public FacetsSaxParser(InputStream xml) throws IOException, ParserConfigurationException, SAXException, FactoryConfigurationError {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(new InputSource(xml), (DefaultHandler)this);
        if (logger.isInfoEnabled()) {
            logger.info("Stream parsed OK, " + this.descriptors.size() + " descriptors loaded");
        }
    }

    public FacetDescriptor[] getDescriptors() {
        FacetDescriptor[] res = new FacetDescriptor[this.descriptors.size()];
        res = this.descriptors.toArray(res);
        return res;
    }

    public void startDocument() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting XML parsing...");
        }
    }

    public void startElement(String uri, String local, String qName, Attributes atts) {
        if (qName.equals("facet")) {
            if (logger.isDebugEnabled()) {
                logger.debug("startElement() : found a facet...");
            }
            String facetName = null;
            String profile = null;
            Class<?> objectType = null;
            Class<?> facetClass = null;
            for (int i = 0; i < atts.getLength(); ++i) {
                String attrName = atts.getQName(i);
                String attrVal = atts.getValue(attrName);
                if (attrName.equals("name")) {
                    facetName = attrVal;
                } else if (attrName.equals("profile")) {
                    profile = attrVal;
                } else if (attrName.equals("object_type")) {
                    try {
                        objectType = Class.forName(attrVal);
                    }
                    catch (ClassNotFoundException cnfex) {
                        logger.warn("ClassNotFoundException caught ! Type could not be resolved (name=" + facetName + " profile=" + profile + " objectType=" + objectType + ") - DESCRIPTOR SKIPPED");
                        ++this.nbSkipped;
                    }
                } else if (attrName.equals("class")) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Trying to retrieve Class=" + attrVal + "...");
                        }
                        facetClass = Class.forName(attrVal);
                        if (logger.isDebugEnabled()) {
                            logger.debug("... OK, Class=" + facetClass);
                        }
                    }
                    catch (ClassNotFoundException cnfex) {
                        logger.warn("ClassNotFoundException caught ! Class '" + attrVal + "' could not be resolved, Class.forName() failed ! - DESCRIPTOR SKIPPED");
                    }
                }
                if (i != atts.getLength() - 1 || facetName == null || profile == null || objectType == null || facetClass == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating descriptor...");
                }
                FacetDescriptor d = new FacetDescriptor();
                d.setName(facetName);
                d.setProfileId(profile);
                d.setTargetObjectType(objectType);
                d.setFacetClass(facetClass);
                this.descriptors.add(d);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("facet descriptor created OK (" + d + ") and added to list");
            }
        }
    }

    public void characters(char[] text, int start, int length) {
    }

    public void endElement(String uri, String local, String qName) {
    }

    public void endDocument() {
        if (logger.isInfoEnabled()) {
            logger.info("Facets XML descriptor parsing over : found " + this.descriptors.size() + " descriptor(s)");
        }
    }
}

