/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.impl;

import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetFactory;
import net.sourceforge.jfacets.log.JFacetsLogger;

public class DefaultFacetFactory
implements IFacetFactory {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(DefaultFacetFactory.class);

    public Object createFacet(FacetDescriptor d) {
        Class facetClass;
        if (logger.isDebugEnabled()) {
            logger.debug("createFacet() : attempting to create facet for descriptor " + d + "...");
        }
        if ((facetClass = d.getFacetClass()) == null) {
            logger.error("createFacet() : facetClass is null in supplied descriptor !");
            return null;
        }
        try {
            Object facet = facetClass.newInstance();
            if (logger.isDebugEnabled()) {
                logger.debug("createFacet() : facet created OK, returning " + facet);
            }
            return facet;
        }
        catch (Throwable e) {
            logger.error("createFacet() : unable to create using no-args constructor, exception caught !", e);
            return null;
        }
    }
}

