/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets;

import net.sourceforge.jfacets.IFacetContextFactory;
import net.sourceforge.jfacets.IFacetDescriptorManager;
import net.sourceforge.jfacets.IFacetFactory;
import net.sourceforge.jfacets.IProfileRepository;
import net.sourceforge.jfacets.JFacets;
import net.sourceforge.jfacets.impl.DefaultFacetContextFactory;
import net.sourceforge.jfacets.impl.DefaultFacetFactory;
import net.sourceforge.jfacets.impl.FacetRepositoryImpl;
import net.sourceforge.jfacets.log.JFacetsLogger;

public class JFacetsBuilder {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(JFacetsBuilder.class);
    private IProfileRepository profileRepository;
    private IFacetDescriptorManager facetDescriptorManager;
    private IFacetFactory facetFactory = new DefaultFacetFactory();
    private IFacetContextFactory facetContextFactory = new DefaultFacetContextFactory();
    private String fallbackProfileId;
    private boolean useProfilesCache = false;

    public JFacetsBuilder(IProfileRepository profileRepository, IFacetDescriptorManager facetDescriptorManager) {
        this.profileRepository = profileRepository;
        this.facetDescriptorManager = facetDescriptorManager;
    }

    public JFacetsBuilder setFacetFactory(IFacetFactory facetFactory) {
        this.facetFactory = facetFactory;
        return this;
    }

    public JFacetsBuilder setFacetContextFactory(IFacetContextFactory facetContextFactory) {
        this.facetContextFactory = facetContextFactory;
        return this;
    }

    public JFacets build() {
        FacetRepositoryImpl facetRepository = new FacetRepositoryImpl(this.profileRepository, this.facetFactory, this.facetContextFactory, this.facetDescriptorManager);
        JFacets jFacets = new JFacets();
        jFacets.setFacetRepository(facetRepository);
        if (this.fallbackProfileId != null) {
            jFacets.setFallbackProfileId(this.fallbackProfileId);
        }
        jFacets.setUseProfilesCache(this.useProfilesCache);
        try {
            jFacets.afterPropertiesSet();
        }
        catch (Exception e) {
            logger.error("Exception caught while initializing the JFacets bean !", e);
            jFacets = null;
        }
        return jFacets;
    }

    public JFacetsBuilder setFallbackProfileId(String fallbackProfileId) {
        this.fallbackProfileId = fallbackProfileId;
        return this;
    }

    public JFacetsBuilder setUseProfilesCache(boolean useProfilesCache) {
        this.useProfilesCache = useProfilesCache;
        return this;
    }
}

