/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacet;
import net.sourceforge.jfacets.IFacetContext;
import net.sourceforge.jfacets.IFacetContextFactory;
import net.sourceforge.jfacets.IFacetDescriptorManager;
import net.sourceforge.jfacets.IFacetFactory;
import net.sourceforge.jfacets.IFacetRepository;
import net.sourceforge.jfacets.IInitializableFacet;
import net.sourceforge.jfacets.IInstanceFacet;
import net.sourceforge.jfacets.IProfile;
import net.sourceforge.jfacets.IProfileRepository;
import net.sourceforge.jfacets.log.JFacetsLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetRepositoryImpl
implements IFacetRepository {
    private IProfileRepository profileRepo = null;
    private IFacetFactory facetFactory;
    private IFacetContextFactory facetContextFactory;
    private IFacetDescriptorManager facetDescriptorManager;
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(FacetRepositoryImpl.class);

    public FacetRepositoryImpl(IProfileRepository pRepo, IFacetFactory facetFactory, IFacetContextFactory facetContextFactory, IFacetDescriptorManager facetDescriptorManager) {
        this.profileRepo = pRepo;
        this.facetFactory = facetFactory;
        this.facetContextFactory = facetContextFactory;
        this.facetDescriptorManager = facetDescriptorManager;
    }

    public static Class[] getDirectSuperTypes(Class objectType) {
        if (objectType.isInterface()) {
            return objectType.getInterfaces();
        }
        Class superClass = objectType.getSuperclass();
        if (superClass == null) {
            return new Class[0];
        }
        Class<?>[] intfs = objectType.getInterfaces();
        Class[] allTypes = new Class[intfs.length + 1];
        for (int i = 0; i < intfs.length; ++i) {
            allTypes[i] = intfs[i];
        }
        allTypes[intfs.length] = superClass;
        return allTypes;
    }

    @Override
    public FacetDescriptor[] getDescriptors(IProfile profile, Class targetObjectType) {
        if (logger.isDebugEnabled()) {
            logger.debug("getting facet descriptors for profile id " + profile.getId() + " and type = " + targetObjectType);
        }
        FacetDescriptor[] descriptors = this.facetDescriptorManager.getDescriptors();
        ArrayList<FacetDescriptor> res = new ArrayList<FacetDescriptor>();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getProfileId().equals(profile.getId())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("descriptor " + descriptors[i] + " matches profile");
            }
            if (descriptors[i].getTargetObjectType().isAssignableFrom(targetObjectType)) {
                res.add(descriptors[i]);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("  -> was compatible, added");
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("  -> was not compatible, skipped");
        }
        IProfile[] superProfiles = this.profileRepo.getSuperProfiles(profile);
        for (int j = 0; j < superProfiles.length; ++j) {
            FacetDescriptor[] fds = this.getDescriptors(superProfiles[j], targetObjectType);
            List<FacetDescriptor> lst = Arrays.asList(fds);
            res.addAll(lst);
        }
        FacetDescriptor[] resA = new FacetDescriptor[res.size()];
        resA = res.toArray(resA);
        if (logger.isDebugEnabled()) {
            logger.debug("OK returning " + resA.length + " descriptors");
        }
        return resA;
    }

    @Override
    public IProfileRepository getProfileRepository() {
        return this.profileRepo;
    }

    @Override
    public IFacetFactory getFacetFactory() {
        return this.facetFactory;
    }

    @Override
    public IFacetContextFactory getFacetContextFactory() {
        return this.facetContextFactory;
    }

    @Override
    public IFacetDescriptorManager getFacetDescriptorManager() {
        return this.facetDescriptorManager;
    }

    @Override
    public Object getFacet(String facetName, IProfile profile, Object targetObject) {
        if (logger.isDebugEnabled()) {
            logger.debug("getFacet() : invoked with parameters : facetName='" + facetName + "', profileId='" + profile.getId() + "', and targetObject='" + targetObject + "'...");
        }
        return this.getFacet(facetName, profile, targetObject, targetObject.getClass());
    }

    @Override
    public Object getFacet(String name, IProfile profile, Object targetObject, Class targetObjectType) {
        ArrayList<FacetDescriptor> discardedDescriptors;
        Object facet;
        if (logger.isDebugEnabled()) {
            logger.debug("trying to retrieve facet name='" + name + "', profileId='" + profile.getId() + "',  targetObject='" + targetObject + "', targetObjectType='" + targetObjectType + "'...");
        }
        if ((facet = this.climbProfiles(name, profile, targetObject, targetObjectType, discardedDescriptors = new ArrayList<FacetDescriptor>())) != null && facet instanceof IInitializableFacet) {
            if (logger.isDebugEnabled()) {
                logger.debug("facet implements IInitializableFacet : initializing it");
            }
            ((IInitializableFacet)facet).initializeFacet();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("returning " + facet);
        }
        return facet;
    }

    private Object climbProfiles(String facetName, IProfile profile, Object targetObject, Class targetObjectClass, List<FacetDescriptor> discardedDescriptors) {
        ArrayList<Class> alreadyCheckedClasses = new ArrayList<Class>();
        Object facet = this.climbTypes(facetName, profile, targetObject, targetObjectClass, alreadyCheckedClasses, discardedDescriptors);
        if (facet == null) {
            IProfile parent;
            IProfile[] parents;
            IProfile[] arr$ = parents = this.getProfileRepository().getSuperProfiles(profile);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (facet = this.climbProfiles(facetName, parent = arr$[i$], targetObject, targetObjectClass, discardedDescriptors)) == null; ++i$) {
            }
        }
        return facet;
    }

    private Object climbTypes(String facetName, IProfile profile, Object targetObject, Class targetObjectClass, List<Class> alreadyCheckedClasses, List<FacetDescriptor> discardedDescriptors) {
        if (logger.isDebugEnabled()) {
            logger.debug("trying to get descriptor (" + facetName + "," + profile.getId() + "," + targetObject + "," + targetObjectClass + ")");
        }
        Object facet = null;
        FacetDescriptor fd = this.facetDescriptorManager.getDescriptor(facetName, profile.getId(), targetObjectClass);
        alreadyCheckedClasses.add(targetObjectClass);
        if (fd == null || discardedDescriptors.contains(fd)) {
            Class[] directSuperTypes;
            if (logger.isDebugEnabled()) {
                logger.debug("descriptor not found, climbing supertype(s)...");
            }
            for (Class superType : directSuperTypes = FacetRepositoryImpl.getDirectSuperTypes(targetObjectClass)) {
                if (!alreadyCheckedClasses.contains(superType) && (facet = this.climbTypes(facetName, profile, targetObject, superType, alreadyCheckedClasses, discardedDescriptors)) != null) break;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("descriptor found : " + fd + ", creating facet...");
            }
            facet = this.facetFactory.createFacet(fd);
            if (logger.isDebugEnabled()) {
                logger.debug("facet created : " + facet);
            }
            if (facet instanceof IFacet) {
                if (logger.isDebugEnabled()) {
                    logger.debug("implements IFacet, creating and setting context...");
                }
                IFacetContext ctx = this.facetContextFactory.create(facetName, profile, targetObject, fd);
                ((IFacet)facet).setFacetContext(ctx);
                if (logger.isDebugEnabled()) {
                    logger.debug("context created and assigned : " + ctx);
                }
            }
            if (facet instanceof IInstanceFacet) {
                if (logger.isDebugEnabled()) {
                    logger.debug("implements IInstanceFacet, checking wether it matches or not...");
                }
                if (((IInstanceFacet)facet).matchesTargetObject(targetObject)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("instance facet " + facet + " is matching");
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("instance facet " + facet + " is NOT matching ! continue to search");
                    }
                    discardedDescriptors.add(fd);
                    facet = this.climbTypes(facetName, profile, targetObject, targetObjectClass, alreadyCheckedClasses, discardedDescriptors);
                }
            }
        }
        return facet;
    }
}

