/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetDescriptorManager;
import net.sourceforge.jfacets.impl.FacetsSaxParser;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.xml.sax.SAXException;

public class FacetDescriptorManager
implements IFacetDescriptorManager {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(FacetDescriptorManager.class);
    private FacetDescriptor[] descriptors = null;
    private String facetsFilePath = null;

    public FacetDescriptorManager(String facetsFilePath) throws IOException, ParserConfigurationException, SAXException, FactoryConfigurationError {
        this.facetsFilePath = facetsFilePath;
        if (!this.facetsFilePath.startsWith("/")) {
            this.facetsFilePath = "/" + this.facetsFilePath;
        }
        int nbDesc = this.loadDescriptors();
        if (logger.isInfoEnabled()) {
            logger.info("FacetDescriptorManager created, " + nbDesc + " descriptor(s) loaded");
        }
    }

    protected int loadDescriptors() throws IOException, ParserConfigurationException, SAXException, FactoryConfigurationError {
        if (logger.isDebugEnabled()) {
            logger.debug("loadDescriptors() : getting facets XML file from " + this.facetsFilePath);
        }
        InputStream is = this.getClass().getResourceAsStream(this.facetsFilePath);
        if (logger.isDebugEnabled()) {
            logger.debug("loadDescriptors() : parsing...");
        }
        FacetsSaxParser parser = new FacetsSaxParser(is);
        if (logger.isDebugEnabled()) {
            logger.debug("loadDescriptors() : ... parsed");
        }
        this.descriptors = parser.getDescriptors();
        if (logger.isDebugEnabled()) {
            logger.debug("loadDescriptors() : " + this.descriptors.length + " descriptors loaded OK");
        }
        return this.descriptors.length;
    }

    public FacetDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public FacetDescriptor getDescriptor(String name, String profileId, Class targetObjectType) {
        if (logger.isDebugEnabled()) {
            logger.debug("getDescriptor() : trying to get descriptor for name='" + name + "' profileId='" + profileId + "' " + "objType='" + targetObjectType.getName() + "' ...");
        }
        FacetDescriptor d = null;
        for (int i = 0; i < this.descriptors.length && d == null; ++i) {
            if (!name.equals(this.descriptors[i].getName()) || !profileId.equals(this.descriptors[i].getProfileId()) || !targetObjectType.getName().equals(this.descriptors[i].getTargetObjectType().getName())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("getDescriptor() : ... descriptor found OK");
            }
            d = this.descriptors[i];
        }
        return d;
    }
}

