/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.annotations;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetDescriptorManager;
import net.sourceforge.jfacets.annotations.DuplicatedKeyException;
import net.sourceforge.jfacets.annotations.DuplicatedKeyPolicyType;
import net.sourceforge.jfacets.annotations.FacetKey;
import net.sourceforge.jfacets.annotations.FacetKeyList;
import net.sourceforge.jfacets.log.JFacetsLogger;
import net.sourceforge.jfacets.util.ResolverUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedFacetDescriptorManager
implements IFacetDescriptorManager {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(AnnotatedFacetDescriptorManager.class);
    private List<String> basePackages;
    private ArrayList<FacetDescriptor> descriptors = new ArrayList();
    private int nbDesc = 0;
    private ClassLoader classLoader;
    private DuplicatedKeyPolicyType duplicatedKeyPolicy = DuplicatedKeyPolicyType.ThrowException;

    public AnnotatedFacetDescriptorManager(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    public AnnotatedFacetDescriptorManager setDuplicatedKeyPolicy(DuplicatedKeyPolicyType policyType) {
        this.duplicatedKeyPolicy = policyType;
        return this;
    }

    public AnnotatedFacetDescriptorManager setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DuplicatedKeyPolicyType getDuplicatedKeyPolicy() {
        return this.duplicatedKeyPolicy;
    }

    public AnnotatedFacetDescriptorManager initialize() {
        if (this.basePackages == null || this.basePackages.size() == 0) {
            logger.warn("No base packages have been defined, as a result no annotated facet can be found ! Please set the basePackages property of the AnnotatedFacetDescriptorManager.");
        }
        for (String pkg : this.basePackages) {
            if (logger.isDebugEnabled()) {
                logger.debug("Scanning package " + pkg);
            }
            ResolverUtil resolverUtil = new ResolverUtil();
            if (this.classLoader != null) {
                logger.debug("Using supplied class loader " + this.classLoader);
                resolverUtil.setClassLoader(this.classLoader);
            }
            resolverUtil.findAnnotated(FacetKey.class, pkg);
            resolverUtil.findAnnotated(FacetKeyList.class, pkg);
            for (Class clazz : resolverUtil.getClasses()) {
                FacetKeyList fkl = clazz.getAnnotation(FacetKeyList.class);
                if (fkl != null) {
                    FacetKey[] facetKeys;
                    for (FacetKey facetKey : facetKeys = fkl.keys()) {
                        this.createDescriptorForAnnotation(facetKey, clazz);
                    }
                    continue;
                }
                FacetKey annot = clazz.getAnnotation(FacetKey.class);
                if (annot != null) {
                    this.createDescriptorForAnnotation(annot, clazz);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Skipped class " + clazz + ", does not have the @FacetKey annot");
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("init OK, " + this.nbDesc + " descriptors loaded");
        }
        return this;
    }

    private void createDescriptorForAnnotation(FacetKey annot, Class facetClass) {
        String name = annot.name();
        String profileId = annot.profileId();
        Class targetObjectType = annot.targetObjectType();
        if (name != null && profileId != null && targetObjectType != null) {
            FacetDescriptor dup = this.getDescriptor(name, profileId, targetObjectType);
            if (dup != null) {
                switch (this.duplicatedKeyPolicy) {
                    case ThrowException: {
                        throw new DuplicatedKeyException(name, profileId, targetObjectType);
                    }
                    case FirstScannedWins: {
                        logger.info("Ignoring duplicated facet key (" + name + "," + profileId + "," + targetObjectType + "), policy is set to first scanned wins");
                    }
                }
            } else {
                FacetDescriptor descriptor = new FacetDescriptor();
                descriptor.setName(name);
                descriptor.setProfileId(profileId);
                descriptor.setTargetObjectType(targetObjectType);
                descriptor.setFacetClass(facetClass);
                this.descriptors.add(descriptor);
                ++this.nbDesc;
                if (logger.isDebugEnabled()) {
                    logger.debug("Created and added descriptor " + descriptor + " for annotated facet class " + facetClass);
                }
            }
        } else {
            logger.warn("Class " + facetClass + " has the @FacetKey annot but some attributes are missing ! name, profileId and targetObjectType are required");
        }
    }

    @Override
    public FacetDescriptor getDescriptor(String name, String profileId, Class targetObjectType) {
        FacetDescriptor res = null;
        for (FacetDescriptor d : this.descriptors) {
            if (!d.getName().equals(name) || !d.getProfileId().equals(profileId) || !d.getTargetObjectType().equals(targetObjectType)) continue;
            res = d;
            break;
        }
        return res;
    }

    @Override
    public FacetDescriptor[] getDescriptors() {
        FacetDescriptor[] res = new FacetDescriptor[this.descriptors.size()];
        res = this.descriptors.toArray(res);
        return res;
    }
}

