/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets;

import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.jfacets.FacetDescriptor;
import net.sourceforge.jfacets.IFacetRepository;
import net.sourceforge.jfacets.IProfile;
import net.sourceforge.jfacets.IProfileRepository;
import net.sourceforge.jfacets.log.JFacetsLogger;

public class JFacets {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(JFacets.class);
    private boolean useProfilesCache = false;
    private ConcurrentHashMap<String, IProfile> profilesCache;
    private String fallbackProfileId = null;
    private IFacetRepository facetRepository;

    protected IProfile getProfile(String profileId) {
        if (profileId == null) {
            if (this.fallbackProfileId != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("supplied profile ID is null, trying fallbackProfileId '" + this.fallbackProfileId + "'");
                }
                profileId = this.fallbackProfileId;
            } else {
                logger.warn("Supplied profileId is null ! If you plan to pass null profile IDs then consider using the fallbackProfileId feature !");
                return null;
            }
        }
        IProfile res = null;
        if (this.useProfilesCache) {
            res = this.profilesCache.get(profileId);
        }
        if (res != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Profile obtained from cache, using it !");
            }
        } else {
            IProfileRepository profileRepository = this.facetRepository.getProfileRepository();
            res = profileRepository.getProfileById(profileId);
            if (res == null) {
                logger.warn("Profile not found for ID " + profileId + " using pRepo !");
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Profile obtained from the repository, returning " + res.toString());
                }
                if (this.useProfilesCache) {
                    this.profilesCache.put(profileId, res);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using profiles cache, profile " + res + " added to cache");
                    }
                }
            }
        }
        return res;
    }

    public void clearCache() {
        this.profilesCache.clear();
    }

    public Object getFacet(String facetName, String profileId, Object targetObject, Class targetObjectClass) {
        IProfile profile;
        if (logger.isInfoEnabled()) {
            logger.info("Attempting to retrieve facet for key (" + facetName + ", " + profileId + ", " + targetObjectClass + ", with targetObject=" + targetObject + ")...");
        }
        if ((profile = this.getProfile(profileId)) == null) {
            logger.warn("Profile not found for id " + profileId + " ! returning null");
            return null;
        }
        Object facet = this.facetRepository.getFacet(facetName, profile, targetObject, targetObjectClass);
        if (logger.isInfoEnabled()) {
            logger.info("returning facet " + facet);
        }
        return facet;
    }

    public Object getFacet(String facetName, String profileId, Object targetObject) {
        IProfile profile;
        if (logger.isInfoEnabled()) {
            logger.info("Attempting to retrieve facet for key (" + facetName + ", " + profileId + ", " + targetObject.getClass() + ")...");
        }
        if ((profile = this.getProfile(profileId)) == null) {
            logger.warn("Profile not found for id " + profileId + " ! returning null");
            return null;
        }
        Object facet = this.facetRepository.getFacet(facetName, profile, targetObject);
        if (logger.isInfoEnabled()) {
            logger.info("returning facet " + facet);
        }
        return facet;
    }

    public Object getFacet(String facetName, String profileId) {
        if (logger.isInfoEnabled()) {
            logger.info("Attempting to retrieve facet for key (" + facetName + ", " + profileId + " with no target object (dummy Object will be used instead)");
        }
        return this.getFacet(facetName, profileId, new Object());
    }

    public IFacetRepository getFacetRepository() {
        return this.facetRepository;
    }

    public void setFacetRepository(IFacetRepository facetRepository) {
        this.facetRepository = facetRepository;
    }

    public IProfileRepository getProfileRepository() {
        return this.facetRepository.getProfileRepository();
    }

    public String getFallbackProfileId() {
        return this.fallbackProfileId;
    }

    public void setFallbackProfileId(String fallbackProfileId) {
        this.fallbackProfileId = fallbackProfileId;
    }

    public void afterPropertiesSet() {
        if (this.facetRepository == null) {
            throw new IllegalStateException("FacetRepository has not been set !");
        }
        if (this.useProfilesCache) {
            this.profilesCache = new ConcurrentHashMap();
            if (logger.isInfoEnabled()) {
                logger.info("Using profiles cache !");
            }
        }
    }

    public boolean isUseProfilesCache() {
        return this.useProfilesCache;
    }

    public void setUseProfilesCache(boolean useProfilesCache) {
        this.useProfilesCache = useProfilesCache;
    }

    public String dumpFacetsAsXml() {
        StringBuffer res = new StringBuffer();
        res.append("<facets>\n");
        FacetDescriptor[] descriptors = this.getFacetRepository().getFacetDescriptorManager().getDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!JFacets.isDescriptorOk(descriptors[i])) continue;
            res.append("  <facet name=\"");
            res.append(descriptors[i].getName());
            res.append("\" profile=\"");
            res.append(descriptors[i].getProfileId());
            res.append("\" object_type=\"");
            res.append(descriptors[i].getTargetObjectType().getName());
            res.append("\" class=\"");
            res.append(descriptors[i].getFacetClass().getName());
            res.append("\"/>\n");
        }
        res.append("</facets>\n");
        return res.toString();
    }

    private static boolean isDescriptorOk(FacetDescriptor fd) {
        return fd.getName() != null && fd.getProfileId() != null && fd.getTargetObjectType() != null && fd.getFacetClass() != null;
    }
}

