/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.acegi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.jfacets.acegi.HierarchicalUserDetails;
import net.sourceforge.jfacets.acegi.INavigableHierarchicalUserDetailsService;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.memory.InMemoryDaoImpl;
import org.acegisecurity.userdetails.memory.UserMap;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

public class InMemoryHierarchicalUDS
extends InMemoryDaoImpl
implements INavigableHierarchicalUserDetailsService {
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(InMemoryHierarchicalUDS.class);
    private Properties roleProperties;
    private boolean wrapUserDetails = true;
    private HashMap<String, GrantedAuthority> roles = new HashMap();
    private HashMap<GrantedAuthority, ArrayList<GrantedAuthority>> rolesAndParents = new HashMap();
    private HashMap<String, UserDetails> userNamesAndDetails = new HashMap();
    private int loadedRolesCount = 0;

    public void setRoleProperties(Properties roleProperties) {
        this.roleProperties = roleProperties;
    }

    public void setUserProperties(Properties userProperties) {
        super.setUserProperties(userProperties);
        for (String string : userProperties.keySet()) {
            this.userNamesAndDetails.put(string, null);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.roleProperties, (String)"A list of roles and their hierarchical structure must be set");
        super.afterPropertiesSet();
        this.loadRoles();
        this.loadUsers();
    }

    private void loadRoles() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Loading roles...");
        }
        Iterator<Object> iter = this.roleProperties.keySet().iterator();
        while (iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            String roleName = (String)iter.next();
            if (roleName == null || roleName.equals("")) continue;
            sb.append(" - ");
            sb.append(roleName);
            sb.append(" : parents=");
            GrantedAuthority ga = this.getOrCreate(roleName);
            String rolesStr = this.roleProperties.getProperty(roleName);
            String[] tokens = rolesStr.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                String parentName = tokens[i].trim();
                if (parentName == null || parentName.equals("")) continue;
                GrantedAuthority parent = this.getOrCreate(parentName);
                this.addToParents(ga, parent);
                sb.append(parentName);
                if (i >= tokens.length - 1) continue;
                sb.append(", ");
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)sb.toString());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("OK, " + this.loadedRolesCount + " roles loaded"));
        }
    }

    private void loadUsers() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Loading users...");
        }
        UserMap userMap = this.getUserMap();
        ArrayList<String> userNames = new ArrayList<String>(this.userNamesAndDetails.keySet());
        for (String userName : userNames) {
            UserDetails ud = userMap.getUser(userName);
            this.userNamesAndDetails.put(userName, ud);
        }
    }

    private GrantedAuthority getOrCreate(String name) {
        GrantedAuthority res = this.roles.get(name);
        if (res == null) {
            res = new GrantedAuthorityImpl(name);
            this.roles.put(name, res);
            ++this.loadedRolesCount;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getOrCreate() : Role : " + name + " created (ga.toString()=" + res + ")"));
            }
        }
        return res;
    }

    private void addToParents(GrantedAuthority child, GrantedAuthority parent) {
        ArrayList<Object> parents = this.rolesAndParents.get(child);
        if (parents == null) {
            parents = new ArrayList();
            this.rolesAndParents.put(child, parents);
        }
        if (!parents.contains(parent)) {
            parents.add(parent);
        }
    }

    public GrantedAuthority getGrantedAuthority(String roleName) {
        return this.roles.get(roleName);
    }

    public GrantedAuthority[] getParentRoles(GrantedAuthority grantedAuthority) {
        ArrayList<GrantedAuthority> res = this.rolesAndParents.get(grantedAuthority);
        if (res == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getParentRoles() - Role " + grantedAuthority + " has no parents"));
            }
            return null;
        }
        GrantedAuthority[] gas = new GrantedAuthority[res.size()];
        gas = res.toArray(gas);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getParentRoles() - returning parent roles " + gas + " for " + grantedAuthority));
        }
        return gas;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        UserDetails ud = super.loadUserByUsername(username);
        if (ud == null) {
            logger.warn((Object)("loadUserByUsername : use not found for name " + username + " returning null"));
            return null;
        }
        if (this.wrapUserDetails) {
            HierarchicalUserDetails hud = new HierarchicalUserDetails(this, ud);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadUserByUsername : Wrapping user '" + username + "' into HierarchicalUserDetails : " + hud));
            }
            return hud;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadUserByUsername : Returning user '" + username + "' into UserDetails : " + ud));
        }
        return ud;
    }

    public boolean isWrapUserDetails() {
        return this.wrapUserDetails;
    }

    public void setWrapUserDetails(boolean wrapUserDetails) {
        this.wrapUserDetails = wrapUserDetails;
    }

    public GrantedAuthority[] getRootRoles() {
        ArrayList<GrantedAuthority> res = new ArrayList<GrantedAuthority>();
        for (GrantedAuthority ga : this.roles.values()) {
            List parents = this.rolesAndParents.get(ga);
            if (parents != null && parents.size() != 0) continue;
            res.add(ga);
        }
        GrantedAuthority[] rootRoles = new GrantedAuthority[res.size()];
        rootRoles = res.toArray(rootRoles);
        return rootRoles;
    }

    public GrantedAuthority[] getChildRoles(GrantedAuthority parentRole) {
        ArrayList<GrantedAuthority> res = new ArrayList<GrantedAuthority>();
        for (GrantedAuthority ga : this.roles.values()) {
            List parents = this.rolesAndParents.get(ga);
            if (parents == null || !parents.contains(parentRole)) continue;
            res.add(ga);
        }
        GrantedAuthority[] childRoles = new GrantedAuthority[res.size()];
        childRoles = res.toArray(childRoles);
        return childRoles;
    }

    public UserDetails[] getUsersInRole(GrantedAuthority role) {
        ArrayList<UserDetails> res = new ArrayList<UserDetails>();
        block0: for (UserDetails ud : this.userNamesAndDetails.values()) {
            GrantedAuthority[] userRoles = ud.getAuthorities();
            for (int i = 0; i < userRoles.length; ++i) {
                if (!userRoles[i].equals(role)) continue;
                res.add(ud);
                continue block0;
            }
        }
        UserDetails[] uds = new UserDetails[res.size()];
        uds = res.toArray(uds);
        return uds;
    }
}

