/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.acegi;

import java.util.ArrayList;
import net.sourceforge.jfacets.acegi.IHierarchicalUserDetailsService;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;

public class HierarchicalUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(HierarchicalUserDetails.class);
    private UserDetails delegate;
    private IHierarchicalUserDetailsService huds;
    private ArrayList<GrantedAuthority> allAuthorities = new ArrayList();

    public HierarchicalUserDetails(IHierarchicalUserDetailsService huds, UserDetails delegate) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating wrapper for UserDetails : " + delegate + " (username=" + delegate.getUsername() + ")"));
        }
        this.huds = huds;
        this.delegate = delegate;
        this.loadAllAuthorities(delegate.getAuthorities());
        StringBuffer sb = new StringBuffer();
        for (GrantedAuthority ga : this.allAuthorities) {
            sb.append(ga.getAuthority());
            sb.append(" ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Wrapper created, all authorities = " + sb.toString()));
        }
    }

    private void loadAllAuthorities(GrantedAuthority[] authorities) {
        for (int i = 0; i < authorities.length; ++i) {
            GrantedAuthority[] parents;
            if (!this.allAuthorities.contains(authorities[i])) {
                this.allAuthorities.add(authorities[i]);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Added GA " + authorities[i]));
                }
            }
            if ((parents = this.huds.getParentRoles(authorities[i])) == null || parents.length <= 0) continue;
            this.loadAllAuthorities(parents);
        }
    }

    public GrantedAuthority[] getAuthoritiesStrict() {
        return this.delegate.getAuthorities();
    }

    public GrantedAuthority[] getAuthorities() {
        GrantedAuthority[] res = new GrantedAuthority[this.allAuthorities.size()];
        res = this.allAuthorities.toArray(res);
        return res;
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this.delegate.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.delegate.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this.delegate.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public UserDetails getDelegate() {
        return this.delegate;
    }
}

