/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jfacets.acegi;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.jfacets.INavigableProfileRepository;
import net.sourceforge.jfacets.IProfile;
import net.sourceforge.jfacets.acegi.GrantedAuthorityProfile;
import net.sourceforge.jfacets.acegi.HierarchicalUserDetails;
import net.sourceforge.jfacets.acegi.IHierarchicalUserDetailsService;
import net.sourceforge.jfacets.acegi.INavigableHierarchicalUserDetailsService;
import net.sourceforge.jfacets.acegi.UserDetailsProfile;
import net.sourceforge.jfacets.log.JFacetsLogger;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;

public class AcegiProfileRepository
implements INavigableProfileRepository {
    private UserDetailsService userDetailsService;
    private static final JFacetsLogger logger = JFacetsLogger.getLogger(AcegiProfileRepository.class);
    private HashMap<String, UserDetails> cachedUserDetails = new HashMap();
    private boolean useCache = false;

    public IProfile getProfileById(String profileId) {
        GrantedAuthority ga;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getProfileById() - getting profile for ID " + profileId));
        }
        if ((ga = this.getGrantedAuthority(profileId)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getProfileById() - found GA : " + ga));
            }
            return new GrantedAuthorityProfile(ga);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("useCache = " + this.useCache));
        }
        if (this.useCache) {
            UserDetails ud = this.cachedUserDetails.get(profileId);
            if (ud == null && (ud = this.userDetailsService.loadUserByUsername(profileId)) != null) {
                this.cachedUserDetails.put(profileId, ud);
            }
            if (ud == null) {
                logger.warn((Object)("Requested profile ID " + profileId + " does not identify any valid user or role !"));
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getProfileById() - found user details : " + ud));
            }
            return new UserDetailsProfile(ud);
        }
        UserDetails ud = this.userDetailsService.loadUserByUsername(profileId);
        if (ud == null) {
            logger.warn((Object)("Requested profile ID " + profileId + " does not identify any valid user or role !"));
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getProfileById() - found user details : " + ud));
        }
        return new UserDetailsProfile(ud);
    }

    public IProfile[] getSuperProfiles(IProfile profile) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSuperProfiles() : getting super profiles for profile ID = " + profile.getId()));
        }
        if (profile instanceof GrantedAuthorityProfile) {
            GrantedAuthority[] parentRoles = this.getParentRoles(((GrantedAuthorityProfile)profile).getGrantedAuthority());
            if (parentRoles != null && parentRoles.length > 0) {
                ArrayList<GrantedAuthorityProfile> res = new ArrayList<GrantedAuthorityProfile>();
                for (int i = 0; i < parentRoles.length; ++i) {
                    res.add(new GrantedAuthorityProfile(parentRoles[i]));
                }
                IProfile[] superProfiles = new IProfile[res.size()];
                superProfiles = res.toArray(superProfiles);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getSuperProfiles() : returning super roles : " + superProfiles));
                }
                return superProfiles;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getSuperProfiles() : this role has no parents");
            }
            return new IProfile[0];
        }
        if (profile instanceof UserDetailsProfile) {
            UserDetails ud = ((UserDetailsProfile)profile).getUserDetails();
            GrantedAuthority[] roles = ud instanceof HierarchicalUserDetails ? ((HierarchicalUserDetails)ud).getAuthoritiesStrict() : ud.getAuthorities();
            ArrayList<GrantedAuthorityProfile> res = new ArrayList<GrantedAuthorityProfile>();
            for (int i = 0; i < roles.length; ++i) {
                res.add(new GrantedAuthorityProfile(roles[i]));
            }
            IProfile[] superProfiles = new IProfile[res.size()];
            superProfiles = res.toArray(superProfiles);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getSuperProfiles() : returning roles for user : " + superProfiles));
            }
            return superProfiles;
        }
        logger.warn((Object)("getSuperProfiles() : unhandled profile " + profile));
        return new IProfile[0];
    }

    public GrantedAuthority getGrantedAuthority(String roleName) {
        if (this.userDetailsService instanceof IHierarchicalUserDetailsService) {
            IHierarchicalUserDetailsService huds = (IHierarchicalUserDetailsService)this.userDetailsService;
            return huds.getGrantedAuthority(roleName);
        }
        return null;
    }

    public GrantedAuthority[] getParentRoles(GrantedAuthority grantedAuthority) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getParentRoles() : obtaining parent roles for GA " + grantedAuthority));
        }
        if (this.userDetailsService instanceof IHierarchicalUserDetailsService) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getParentRoles() : userDetailsService supports hierarchical roles, delegating");
            }
            IHierarchicalUserDetailsService huds = (IHierarchicalUserDetailsService)this.userDetailsService;
            return huds.getParentRoles(grantedAuthority);
        }
        return null;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public IProfile[] getRootProfiles() {
        if (this.userDetailsService instanceof INavigableHierarchicalUserDetailsService) {
            INavigableHierarchicalUserDetailsService nhuds = (INavigableHierarchicalUserDetailsService)this.userDetailsService;
            GrantedAuthority[] rootRoles = nhuds.getRootRoles();
            IProfile[] res = new IProfile[rootRoles.length];
            for (int i = 0; i < rootRoles.length; ++i) {
                res[i] = new GrantedAuthorityProfile(rootRoles[i]);
            }
            return res;
        }
        logger.warn((Object)"Unable to get root roles : injected UserDetailsService does NOT implement INavigableHierarchicalUserDetailsService !");
        return null;
    }

    public IProfile[] getSubProfiles(IProfile parentProfile) {
        if (parentProfile instanceof UserDetailsProfile) {
            return new IProfile[0];
        }
        if (this.userDetailsService instanceof INavigableHierarchicalUserDetailsService) {
            int i;
            GrantedAuthority ga = ((GrantedAuthorityProfile)parentProfile).getGrantedAuthority();
            INavigableHierarchicalUserDetailsService nhuds = (INavigableHierarchicalUserDetailsService)this.userDetailsService;
            GrantedAuthority[] childRoles = nhuds.getChildRoles(ga);
            UserDetails[] usersInRole = nhuds.getUsersInRole(ga);
            IProfile[] res = new IProfile[childRoles.length + usersInRole.length];
            int indx = 0;
            for (i = 0; i < childRoles.length; ++i) {
                res[indx++] = new GrantedAuthorityProfile(childRoles[i]);
            }
            for (i = 0; i < usersInRole.length; ++i) {
                res[indx++] = new UserDetailsProfile(usersInRole[i]);
            }
            return res;
        }
        logger.warn((Object)"Unable to get sub profiles : injected UserDetailsService does NOT implement INavigableHierarchicalUserDetailsService !");
        return null;
    }
}

