/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.store;

import net.sourceforge.javadpkg.store.FileHash;

public class FileHashImpl
implements FileHash {
    private String name;
    private String path;
    private byte[] hash;
    private String hashAsHex;

    public FileHashImpl(String name, String path, byte[] hash) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (hash == null) {
            throw new IllegalArgumentException("Argument hash is null.");
        }
        this.name = name;
        this.path = path;
        this.hash = (byte[])hash.clone();
        this.hashAsHex = this.createHex(this.hash);
    }

    private String createHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < data.length; ++index) {
            int number = data[index] & 0xFF;
            if (number < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(number));
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public String getHashAsHex() {
        return this.hashAsHex;
    }
}

