/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.io.DataProducer;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.Streams;
import net.sourceforge.javadpkg.io.impl.DataDigestConsumer;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.store.DataStoreNodeComparator;
import net.sourceforge.javadpkg.store.FileHash;
import net.sourceforge.javadpkg.store.FileHashImpl;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class DataStoreNode
implements DebianPackageConstants {
    private DataSource source;
    private String name;
    private String target;
    private FileOwner owner;
    private FileMode mode;
    private Map<String, DataStoreNode> childNodes;
    private DataStoreNode parentNode;

    public DataStoreNode() {
        this.source = null;
        this.name = "";
        this.target = null;
        this.owner = new FileOwnerImpl(0L, "root", 0L, "root");
        this.mode = new FileModeImpl(493);
        this.childNodes = new HashMap<String, DataStoreNode>();
        this.parentNode = null;
    }

    public DataStoreNode(String name, FileOwner owner, FileMode mode) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.source = null;
        this.name = name;
        this.target = null;
        this.owner = owner;
        this.mode = mode;
        this.childNodes = new HashMap<String, DataStoreNode>();
        this.parentNode = null;
    }

    public DataStoreNode(DataSource source, String name, FileOwner owner, FileMode mode) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.source = source;
        this.name = name;
        this.target = null;
        this.owner = owner;
        this.mode = mode;
        this.childNodes = null;
        this.parentNode = null;
    }

    public DataStoreNode(String name, String target, FileOwner owner, FileMode mode) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.source = null;
        this.name = name;
        this.target = target;
        this.owner = owner;
        this.mode = mode;
        this.childNodes = null;
        this.parentNode = null;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        StringBuilder sb = new StringBuilder();
        this.addPath(sb);
        return sb.toString();
    }

    private void addPath(StringBuilder builder) {
        if (this.parentNode != null) {
            this.parentNode.addPath(builder);
        }
        builder.append(this.name);
        if (this.childNodes != null) {
            builder.append('/');
        }
    }

    public boolean isDirectory() {
        return this.childNodes != null;
    }

    public boolean isFile() {
        return this.source != null || this.target != null;
    }

    public boolean isSymbolicLink() {
        return this.target != null;
    }

    public long getSize() throws IOException {
        long size = 0L;
        if (this.childNodes != null) {
            if (!this.childNodes.isEmpty()) {
                for (DataStoreNode node : this.childNodes.values()) {
                    size += node.getSize();
                }
            }
        } else if (this.target == null && (size = this.source.getLength()) < 0L) {
            throw new IOException("Couldn't determine size for file |" + this.getPath() + "| (source |" + this.source.getName() + "|).");
        }
        return size;
    }

    public void addChildNode(DataStoreNode childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException("Argument childNode is null.");
        }
        if (!this.isDirectory()) {
            throw new IllegalStateException("Can't add child node |" + childNode.getName() + "| because this node |" + this.getPath() + "| is not a directory node.");
        }
        if (childNode.getParentNode() != null) {
            throw new IllegalStateException("Can't add child node |" + childNode.getName() + "| because the child node is already added to parent node |" + childNode.getParentNode() + "|.");
        }
        if (this.childNodes.containsKey(childNode.getName())) {
            throw new IllegalStateException("Can't add child node |" + childNode.getName() + "| because this node |" + this.getPath() + "| already contains a child node with that name.");
        }
        childNode.setParentNode(this);
        this.childNodes.put(childNode.getName(), childNode);
    }

    public DataStoreNode getChildNodeByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (this.childNodes == null) {
            throw new IllegalArgumentException("Can't look for child node |" + name + "| because this node |" + this.getPath() + "| is not a directory node.");
        }
        return this.childNodes.get(name);
    }

    private List<DataStoreNode> getChildNodes(boolean sorted) {
        ArrayList<DataStoreNode> nodes = new ArrayList<DataStoreNode>(this.childNodes.values());
        if (sorted) {
            Collections.sort(nodes, new DataStoreNodeComparator());
        }
        return nodes;
    }

    private void setParentNode(DataStoreNode parentNode) {
        this.parentNode = parentNode;
    }

    public DataStoreNode getParentNode() {
        return this.parentNode;
    }

    public void write(TarArchiveOutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        String name = "." + this.getPath();
        TarArchiveEntry entry = this.target == null ? new TarArchiveEntry(name) : new TarArchiveEntry(name, 50);
        entry.setGroupId(this.owner.getGroupId());
        entry.setGroupName(this.owner.getGroupName());
        entry.setUserId(this.owner.getUserId());
        entry.setUserName(this.owner.getUserName());
        entry.setMode(this.mode.getMode());
        if (this.source != null) {
            entry.setSize(this.source.getLength());
        }
        if (this.target != null) {
            entry.setLinkName(this.target);
        }
        out.putArchiveEntry((ArchiveEntry)entry);
        if (this.source != null) {
            this.writeSource((OutputStream)out);
        }
        out.closeArchiveEntry();
        if (this.childNodes != null && !this.childNodes.isEmpty()) {
            this.writeNodes(out);
        }
    }

    private void writeSource(OutputStream out) throws IOException {
        try (InputStream in = this.source.getInputStream();){
            Streams.copy(in, out);
        }
        catch (IOException e) {
            throw new IOException("Couldn't write |" + this.getPath() + "| from source |" + this.source.getName() + "| into the stream: " + e.getMessage());
        }
        if (this.source.isResettable()) {
            this.source.reset();
        }
    }

    private void writeNodes(TarArchiveOutputStream out) throws IOException {
        List<DataStoreNode> nodes = this.getChildNodes(true);
        for (DataStoreNode node : nodes) {
            node.write(out);
        }
    }

    public List<FileHash> createFileHashes(MessageDigest digest) throws IOException {
        if (digest == null) {
            throw new IllegalArgumentException("Argument md is null.");
        }
        ArrayList<FileHash> hashes = new ArrayList<FileHash>();
        if (this.source != null) {
            hashes.add(this.createFileHash(digest));
        } else if (this.childNodes != null && !this.childNodes.isEmpty()) {
            List<DataStoreNode> nodes = this.getChildNodes(true);
            for (DataStoreNode node : nodes) {
                hashes.addAll(node.createFileHashes(digest));
            }
        }
        return hashes;
    }

    private FileHash createFileHash(MessageDigest digest) throws IOException {
        DataProducer producer = Streams.createProducer(this.source);
        DataDigestConsumer consumer = new DataDigestConsumer(digest, "digest");
        digest.reset();
        Streams.transfer(producer, consumer);
        byte[] hash = digest.digest();
        if (this.source.isResettable()) {
            this.source.reset();
        }
        String path = this.getPath();
        FileHashImpl fileHash = new FileHashImpl(this.name, path, hash);
        return fileHash;
    }
}

