/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.store;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import net.sourceforge.javadpkg.DebianPackageConstants;
import net.sourceforge.javadpkg.control.Size;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;
import net.sourceforge.javadpkg.io.impl.FileModeImpl;
import net.sourceforge.javadpkg.io.impl.FileOwnerImpl;
import net.sourceforge.javadpkg.store.DataStore;
import net.sourceforge.javadpkg.store.DataStoreNode;
import net.sourceforge.javadpkg.store.FileHash;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class DataStoreImpl
implements DataStore,
DebianPackageConstants {
    private static final FileOwner DEFAULT_OWNER = new FileOwnerImpl(0L, "root", 0L, "root");
    private static final FileMode DEFAULT_DIRECTORY_MODE = new FileModeImpl(493);
    private static final FileMode DEFAULT_FILE_MODE = new FileModeImpl(420);
    private DataStoreNode rootNode = new DataStoreNode();

    private String[] getPathParts(String path) {
        String line = path;
        if (line.startsWith("./")) {
            line = line.substring(2);
        } else if (line.startsWith(".")) {
            line = line.substring(1);
        } else if (line.startsWith("/")) {
            line = line.substring(1);
        }
        String[] pathParts = line.split("/", 0);
        return pathParts;
    }

    private DataStoreNode getNode(String[] pathParts, int index, int level, DataStoreNode parentNode) {
        if (index >= level) {
            return parentNode;
        }
        String name = pathParts[index];
        DataStoreNode node = parentNode.getChildNodeByName(name);
        if (node == null) {
            return null;
        }
        return this.getNode(pathParts, index + 1, level, node);
    }

    private void addNode(DataSource source, String path, String target, FileOwner owner, FileMode mode) {
        String[] pathParts = this.getPathParts(path);
        if (pathParts.length == 0 || pathParts.length == 1 && pathParts[0].isEmpty()) {
            throw new IllegalArgumentException("Argument path doesn't contain a path: " + path);
        }
        String type = source != null ? "file" : (target != null ? "symbolic link" : "directory");
        DataStoreNode parentNode = this.getNode(pathParts, 0, pathParts.length - 1, this.rootNode);
        if (parentNode == null) {
            throw new IllegalArgumentException("Can't add " + type + " |" + path + "| because the parent directory doesn't exist.");
        }
        if (!parentNode.isDirectory()) {
            throw new IllegalArgumentException("Can't add " + type + " |" + path + "| because the entry |" + parentNode.getPath() + "| is not a directory.");
        }
        String name = pathParts[pathParts.length - 1];
        DataStoreNode node = parentNode.getChildNodeByName(name);
        if (node != null) {
            throw new IllegalArgumentException("Can't add " + type + " because a " + (node.isDirectory() ? "directory" : "file") + " with the path |" + path + "| already exists.");
        }
        node = source != null ? new DataStoreNode(source, name, owner, mode) : (target != null ? new DataStoreNode(name, target, owner, mode) : new DataStoreNode(name, owner, mode));
        parentNode.addChildNode(node);
    }

    @Override
    public void addDirectory(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        this.addDirectory(path, DEFAULT_OWNER, DEFAULT_DIRECTORY_MODE);
    }

    @Override
    public void addDirectory(String path, FileOwner owner, FileMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.addNode(null, path, null, owner, mode);
    }

    @Override
    public void addFile(DataSource source, String path) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        this.addFile(source, path, DEFAULT_OWNER, DEFAULT_FILE_MODE);
    }

    @Override
    public void addFile(DataSource source, String path, FileOwner owner, FileMode mode) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.addNode(source, path, null, owner, mode);
    }

    @Override
    public void addSymLink(String path, String target, FileOwner owner, FileMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument target is null.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        this.addNode(null, path, target, owner, mode);
    }

    @Override
    public boolean exists(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        String[] pathParts = this.getPathParts(path);
        if (pathParts.length == 0 || pathParts.length == 1 && pathParts[0].isEmpty()) {
            throw new IllegalArgumentException("Argument path doesn't contain a path: " + path);
        }
        DataStoreNode node = this.getNode(pathParts, 0, pathParts.length, this.rootNode);
        return node != null;
    }

    @Override
    public Size getSize() throws IOException {
        Size size;
        try {
            size = new Size(this.rootNode.getSize());
        }
        catch (IOException e) {
            throw new IOException("Couldn't determine size of store: " + e.getMessage(), e);
        }
        return size;
    }

    @Override
    public void write(TarArchiveOutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        this.rootNode.write(out);
    }

    @Override
    public List<FileHash> createFileHashes(MessageDigest digest) throws IOException {
        if (digest == null) {
            throw new IllegalArgumentException("Argument digest is null.");
        }
        List<FileHash> hashes = this.rootNode.createFileHashes(digest);
        return hashes;
    }
}

