/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.replace;

import net.sourceforge.javadpkg.Context;
import net.sourceforge.javadpkg.replace.ReplacementException;
import net.sourceforge.javadpkg.replace.ReplacementVariableUnknownWarning;
import net.sourceforge.javadpkg.replace.Replacements;
import net.sourceforge.javadpkg.replace.Replacer;

public class ReplacerImpl
implements Replacer {
    @Override
    public String replace(String line, Replacements replacements, Context context) throws ReplacementException {
        StringBuilder sb = null;
        if (line == null) {
            throw new IllegalArgumentException("Argument line is null.");
        }
        if (replacements == null) {
            throw new IllegalArgumentException("Argument replacements is null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument context is null.");
        }
        if (line.isEmpty()) {
            return line;
        }
        int lastIndex = 0;
        int index = 0;
        while (index != -1) {
            if ((index = line.indexOf("${", index)) >= 0) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(line.substring(lastIndex, index));
                lastIndex = index + 2;
                index = line.indexOf("}", lastIndex);
                if (index == -1) {
                    throw new ReplacementException("Found the beginning of a variable |" + line.substring(lastIndex) + "|, but no end in line |" + line + "|.");
                }
                String name = line.substring(lastIndex, index);
                index = lastIndex = index + 1;
                String value = replacements.getValue(name);
                if (value == null) {
                    context.addWarning(new ReplacementVariableUnknownWarning(name));
                    sb.append("${");
                    sb.append(name);
                    sb.append('}');
                    continue;
                }
                sb.append(value);
                continue;
            }
            if (sb == null) continue;
            sb.append(line.substring(lastIndex));
        }
        if (sb == null) {
            return line;
        }
        return sb.toString();
    }
}

