/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.javadpkg.io.CloseHandler;

public class UncloseableOutputStream
extends OutputStream {
    private OutputStream out;
    private CloseHandler closeHandler;

    public UncloseableOutputStream(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        this.out = out;
        this.closeHandler = null;
    }

    public UncloseableOutputStream(OutputStream out, CloseHandler closeHandler) {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        if (closeHandler == null) {
            throw new IllegalArgumentException("Argument closeHandler is null.");
        }
        this.out = out;
        this.closeHandler = closeHandler;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        if (this.closeHandler != null) {
            this.closeHandler.closed();
        }
    }
}

