/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.javadpkg.io.CloseHandler;

public class UncloseableInputStream
extends InputStream {
    private InputStream in;
    private CloseHandler closeHandler;

    public UncloseableInputStream(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("Argument in is null.");
        }
        this.in = in;
        this.closeHandler = null;
    }

    public UncloseableInputStream(InputStream in, CloseHandler closeHandler) {
        if (in == null) {
            throw new IllegalArgumentException("Argument in is null.");
        }
        if (closeHandler == null) {
            throw new IllegalArgumentException("Argument closeHandler is null.");
        }
        this.in = in;
        this.closeHandler = closeHandler;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.closeHandler != null) {
            this.closeHandler.closed();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }
}

