/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import net.sourceforge.javadpkg.io.FileMode;

public class FileModeImpl
implements FileMode {
    private int mode;

    public FileModeImpl(int mode) {
        if (mode < 0 || mode > 262143) {
            throw new IllegalArgumentException("Argument mode is less than octal 00000 (decimal: 0) or greater than octal 777777 (decimal: 262143): octal " + Integer.toOctalString(mode) + " (decimal: " + mode + ")");
        }
        this.mode = mode;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public String getOctal() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toOctalString(this.mode & 0x1FF));
        while (sb.length() < 3) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        this.addFlag(sb, 'r', this.isOwnerReadable());
        this.addFlag(sb, 'w', this.isOwnerWriteable());
        this.addFlag(sb, 'x', this.isOwnerExecutable());
        this.addFlag(sb, 'r', this.isGroupReadable());
        this.addFlag(sb, 'w', this.isGroupWriteable());
        this.addFlag(sb, 'x', this.isGroupExecutable());
        this.addFlag(sb, 'r', this.isOtherReadable());
        this.addFlag(sb, 'w', this.isOtherWriteable());
        this.addFlag(sb, 'x', this.isOtherExecutable());
        return sb.toString();
    }

    private void addFlag(StringBuilder sb, char flag, boolean value) {
        if (value) {
            sb.append(flag);
        } else {
            sb.append('-');
        }
    }

    @Override
    public int getStickyBit() {
        return this.mode >> 9 & 7;
    }

    @Override
    public boolean isOwnerReadable() {
        return (this.mode & 0x100) != 0;
    }

    @Override
    public boolean isOwnerWriteable() {
        return (this.mode & 0x80) != 0;
    }

    @Override
    public boolean isOwnerExecutable() {
        return (this.mode & 0x40) != 0;
    }

    @Override
    public boolean isGroupReadable() {
        return (this.mode & 0x20) != 0;
    }

    @Override
    public boolean isGroupWriteable() {
        return (this.mode & 0x10) != 0;
    }

    @Override
    public boolean isGroupExecutable() {
        return (this.mode & 8) != 0;
    }

    @Override
    public boolean isOtherReadable() {
        return (this.mode & 4) != 0;
    }

    @Override
    public boolean isOtherWriteable() {
        return (this.mode & 2) != 0;
    }

    @Override
    public boolean isOtherExecutable() {
        return (this.mode & 1) != 0;
    }
}

