/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.util.Date;
import net.sourceforge.javadpkg.io.FileMetaData;
import net.sourceforge.javadpkg.io.FileMode;
import net.sourceforge.javadpkg.io.FileOwner;

public class FileMetaDataImpl
implements FileMetaData {
    private String path;
    private String name;
    private boolean directory;
    private String targetPath;
    private FileOwner owner;
    private FileMode mode;
    private long length;
    private Date lastModifiedDate;

    public FileMetaDataImpl(String path, String name, FileOwner owner, FileMode mode, Date lastModifiedDate) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Argument path is empty.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Argument name contains a slash: " + name);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        this.path = this.revisePath(path);
        if (name.isEmpty() && !"/".equals(path)) {
            throw new IllegalArgumentException("An empty name is only valid for the root. Path: " + path);
        }
        this.name = name;
        this.directory = true;
        this.targetPath = null;
        this.owner = owner;
        this.mode = mode;
        this.length = -1L;
        this.lastModifiedDate = lastModifiedDate;
    }

    public FileMetaDataImpl(FileMetaData parent, String name, FileOwner owner, FileMode mode, Date lastModifiedDate) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Argument parent |" + parent.getAbsolutePath() + "| is not a directory.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("An empty name is only valid for the root. Path: " + parent.getAbsolutePath());
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Argument name contains a slash: " + name);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        this.path = parent.getAbsolutePath();
        this.name = name;
        this.directory = true;
        this.targetPath = null;
        this.owner = owner;
        this.mode = mode;
        this.length = -1L;
        this.lastModifiedDate = lastModifiedDate;
    }

    public FileMetaDataImpl(String path, String name, FileOwner owner, FileMode mode, long length, Date lastModifiedDate) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Argument path is empty.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Argument name is empty.");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Argument name contains a slash: " + name);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (length < -1L) {
            throw new IllegalArgumentException("Argument length is less than -1: " + length);
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        this.path = this.revisePath(path);
        this.name = name;
        this.directory = false;
        this.targetPath = null;
        this.owner = owner;
        this.mode = mode;
        this.length = length;
        this.lastModifiedDate = lastModifiedDate;
    }

    public FileMetaDataImpl(FileMetaData parent, String name, FileOwner owner, FileMode mode, long length, Date lastModifiedDate) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Argument parent |" + parent.getAbsolutePath() + "| is not a directory.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Argument name is empty.");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Argument name contains a slash: " + name);
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (length < -1L) {
            throw new IllegalArgumentException("Argument length is less than -1: " + length);
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        this.path = parent.getAbsolutePath();
        this.name = name;
        this.directory = false;
        this.targetPath = null;
        this.owner = owner;
        this.mode = mode;
        this.length = length;
        this.lastModifiedDate = lastModifiedDate;
    }

    public FileMetaDataImpl(String path, String name, String targetPath, FileOwner owner, FileMode mode, Date lastModifiedDate) {
        if (path == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Argument path is empty.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Argument name contains a slash: " + name);
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("Argument targetPath is null.");
        }
        if (targetPath.isEmpty()) {
            throw new IllegalArgumentException("Argument targetPath is empty.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        this.path = this.revisePath(path);
        this.name = name;
        this.directory = false;
        this.targetPath = targetPath;
        this.owner = owner;
        this.mode = mode;
        this.length = -1L;
        this.lastModifiedDate = lastModifiedDate;
    }

    public FileMetaDataImpl(FileMetaData parent, String name, String targetPath, FileOwner owner, FileMode mode, Date lastModifiedDate) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument path is null.");
        }
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException("Argument parent |" + parent.getAbsolutePath() + "| is not a directory.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("An empty name is only valid for the root. Path: " + parent.getAbsolutePath());
        }
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Argument name contains a slash: " + name);
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("Argument targetPath is null.");
        }
        if (targetPath.isEmpty()) {
            throw new IllegalArgumentException("Argument targetPath is empty.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        this.path = parent.getAbsolutePath();
        this.name = name;
        this.directory = false;
        this.targetPath = targetPath;
        this.owner = owner;
        this.mode = mode;
        this.length = -1L;
        this.lastModifiedDate = lastModifiedDate;
    }

    private String revisePath(String path) {
        String result = path;
        if (result.startsWith("./")) {
            result = result.substring(1);
        }
        if (!result.startsWith("/")) {
            result = '/' + result;
        }
        if (!result.endsWith("/")) {
            result = result + '/';
        }
        return result;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbsolutePath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path);
        sb.append(this.name);
        if (this.directory && !this.name.isEmpty()) {
            sb.append('/');
        }
        return sb.toString();
    }

    @Override
    public boolean isFile() {
        return !this.directory;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.targetPath != null;
    }

    @Override
    public String getTargetPath() {
        return this.targetPath;
    }

    @Override
    public FileOwner getOwner() {
        return this.owner;
    }

    @Override
    public FileMode getMode() {
        return this.mode;
    }

    @Override
    public String getModeAsText() {
        StringBuilder sb = new StringBuilder();
        if (this.directory) {
            sb.append('d');
        } else if (this.targetPath != null) {
            sb.append('l');
        } else {
            sb.append('-');
        }
        sb.append(this.mode.getText());
        return sb.toString();
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public static FileMetaData createDirectoryMetaData(String absolutePath, FileOwner owner, FileMode mode, Date lastModifiedDate) {
        if (absolutePath == null) {
            throw new IllegalArgumentException("Argument absolutePath is null.");
        }
        if (absolutePath.isEmpty()) {
            throw new IllegalArgumentException("Argument absolutePath is empty.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        String[] paths = FileMetaDataImpl.splitAbsolutePath(absolutePath);
        if (paths[1].endsWith("/")) {
            paths[1] = paths[1].substring(0, paths[1].length() - 1);
        }
        FileMetaDataImpl directory = new FileMetaDataImpl(paths[0], paths[1], owner, mode, lastModifiedDate);
        return directory;
    }

    public static FileMetaData createFileMetaData(String absolutePath, FileOwner owner, FileMode mode, long length, Date lastModifiedDate) {
        if (absolutePath == null) {
            throw new IllegalArgumentException("Argument absolutePath is null.");
        }
        if (absolutePath.isEmpty()) {
            throw new IllegalArgumentException("Argument absolutePath is empty.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (length < -1L) {
            throw new IllegalArgumentException("Argument length is less than -1: " + length);
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        String[] paths = FileMetaDataImpl.splitAbsolutePath(absolutePath);
        FileMetaDataImpl file = new FileMetaDataImpl(paths[0], paths[1], owner, mode, length, lastModifiedDate);
        return file;
    }

    public static FileMetaData createSymbolicLinkMetaData(String absolutePath, String targetPath, FileOwner owner, FileMode mode, Date lastModifiedDate) {
        if (absolutePath == null) {
            throw new IllegalArgumentException("Argument absolutePath is null.");
        }
        if (absolutePath.isEmpty()) {
            throw new IllegalArgumentException("Argument absolutePath is empty.");
        }
        if (targetPath == null) {
            throw new IllegalArgumentException("Argument targetPath is null.");
        }
        if (targetPath.isEmpty()) {
            throw new IllegalArgumentException("Argument targetPath is empty.");
        }
        if (owner == null) {
            throw new IllegalArgumentException("Argument owner is null.");
        }
        if (mode == null) {
            throw new IllegalArgumentException("Argument mode is null.");
        }
        if (lastModifiedDate == null) {
            throw new IllegalArgumentException("Argument lastModifiedDate is null.");
        }
        String[] paths = FileMetaDataImpl.splitAbsolutePath(absolutePath);
        FileMetaDataImpl symbolicLink = new FileMetaDataImpl(paths[0], paths[1], targetPath, owner, mode, lastModifiedDate);
        return symbolicLink;
    }

    private static String[] splitAbsolutePath(String absolutePath) {
        String[] result = new String[2];
        String value = absolutePath;
        if (value.startsWith("./")) {
            value = value.substring(1);
        }
        if (!value.startsWith("/")) {
            value = "/" + value;
        }
        if (value.length() == 1) {
            result[0] = "/";
            result[1] = "";
        } else {
            int index = value.lastIndexOf(47);
            if (index == value.length() - 1) {
                index = value.lastIndexOf(47, index - 1);
            }
            result[0] = value.substring(0, index + 1);
            result[1] = value.substring(index + 1);
        }
        return result;
    }
}

