/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.File;
import java.io.IOException;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.DataSwap;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DataFileSource;
import net.sourceforge.javadpkg.io.impl.DataFileTarget;

public class DataTempFileSwap
implements DataSwap {
    private String name;
    private String prefix;
    private String suffix;
    private File file;
    private DataTarget target;
    private DataSource source;
    private boolean closed;

    public DataTempFileSwap(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.name = name;
        this.prefix = "data-temp-file-swap-";
        this.suffix = ".tmp";
        this.file = null;
        this.target = null;
        this.source = null;
        this.closed = false;
    }

    public DataTempFileSwap(String name, String prefix, String suffix) {
        this(name);
        if (prefix == null) {
            throw new IllegalArgumentException("Argument prefix is null.");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Argument suffix is null.");
        }
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public DataTarget getTarget() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't return the target because the swap |" + this.name + "| was already closed.");
        }
        if (this.source != null) {
            throw new IllegalStateException("Can't return the target of the swap |" + this.name + "| because the corresponding source is already open.");
        }
        if (this.target != null) {
            return this.target;
        }
        this.file = File.createTempFile(this.prefix, this.suffix);
        this.target = new DataFileTarget(this.file);
        return this.target;
    }

    @Override
    public DataSource getSource() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't return the source because the swap |" + this.name + "| was already closed.");
        }
        if (this.source != null) {
            return this.source;
        }
        if (this.target == null) {
            throw new IllegalStateException("Can't return the source of the swap |" + this.name + "| because the corresponding target hasn't been opened yet.");
        }
        this.target.close();
        this.source = new DataFileSource(this.file, true);
        return this.source;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.target != null) {
                try {
                    this.target.close();
                }
                catch (IOException e) {
                    throw new IOException("Couldn't close target of swap |" + this.name + "|: " + e.getMessage(), e);
                }
            }
            if (this.source != null) {
                try {
                    this.source.close();
                }
                catch (IOException e) {
                    throw new IOException("Couldn't close source of swap |" + this.name + "|: " + e.getMessage(), e);
                }
            }
            if (this.file != null && this.file.exists() && !this.file.delete()) {
                throw new IOException("Couldn't delete swap |" + this.name + "| (Path: |" + this.file.getAbsolutePath() + "|).");
            }
        }
        finally {
            this.file = null;
            this.target = null;
            this.source = null;
            this.closed = true;
        }
    }
}

