/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.impl.DelegateCloseHandler;
import net.sourceforge.javadpkg.io.impl.UncloseableOutputStream;

public class DataStreamTarget
implements DataTarget {
    private OutputStream out;
    private UncloseableOutputStream publicOut;
    private String name;
    private boolean closeable;

    public DataStreamTarget(OutputStream out, String name, boolean closeable) {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.out = out;
        this.publicOut = null;
        this.name = name;
        this.closeable = closeable;
        this.createPublicOutputStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createPublicOutputStream() {
        this.publicOut = new UncloseableOutputStream(this.out, new DelegateCloseHandler(this));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.publicOut;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.out != null && this.closeable) {
                this.out.close();
            }
        }
        finally {
            this.publicOut = null;
            this.out = null;
        }
    }
}

