/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.javadpkg.io.DataSource;
import net.sourceforge.javadpkg.io.impl.DelegateCloseHandler;
import net.sourceforge.javadpkg.io.impl.UncloseableInputStream;

public class DataStreamSource
implements DataSource {
    private InputStream in;
    private UncloseableInputStream publicIn;
    private String name;
    private boolean closeable;

    public DataStreamSource(InputStream in, String name, boolean closeable) {
        if (in == null) {
            throw new IllegalArgumentException("Argument in is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.in = in;
        this.name = name;
        this.closeable = closeable;
        this.createPublicInputStream();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    @Override
    public boolean isResettable() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Source |" + this.name + "| doesn't support a reset.");
    }

    private void createPublicInputStream() {
        this.publicIn = new UncloseableInputStream(this.in, new DelegateCloseHandler(this));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.publicIn;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.in != null && this.closeable) {
                this.in.close();
            }
        }
        finally {
            this.publicIn = null;
            this.in = null;
        }
    }
}

