/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.javadpkg.io.DataProducer;

public class DataStreamProducer
implements DataProducer {
    private InputStream in;
    private String name;

    public DataStreamProducer(InputStream in, String name) {
        if (in == null) {
            throw new IllegalArgumentException("Argument in is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.in = in;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int produce(byte[] buffer) throws IOException {
        int length;
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer is null.");
        }
        try {
            length = this.in.read(buffer);
        }
        catch (IOException e) {
            throw new IOException("Couldn't read from " + this.name + ": " + e.getMessage(), e);
        }
        return length;
    }
}

