/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.javadpkg.io.DataConsumer;

public class DataStreamConsumer
implements DataConsumer {
    private OutputStream out;
    private String name;

    public DataStreamConsumer(OutputStream out, String name) {
        if (out == null) {
            throw new IllegalArgumentException("Argument out is null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument name is null.");
        }
        this.out = out;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void consume(byte[] buffer, int length) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer is null.");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Argument length is negative: " + length);
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException("Argument length is greater than the buffer length. Length: " + length + "; buffer length: " + buffer.length);
        }
        try {
            this.out.write(buffer, 0, length);
        }
        catch (IOException e) {
            throw new IOException("Couldn't write " + length + " byte(s) to " + this.name + ": " + e.getMessage(), e);
        }
    }
}

