/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javadpkg.io.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.javadpkg.io.DataTarget;
import net.sourceforge.javadpkg.io.Streams;
import net.sourceforge.javadpkg.io.impl.DelegateCloseHandler;
import net.sourceforge.javadpkg.io.impl.UncloseableOutputStream;

public class DataFileTarget
implements DataTarget {
    private File file;
    private OutputStream out;
    private UncloseableOutputStream publicOut;
    private String name;
    private boolean opened;

    public DataFileTarget(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file is null.");
        }
        this.file = file;
        this.out = null;
        this.publicOut = null;
        this.name = file.getAbsolutePath();
        this.opened = false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createPublicOutputStream() {
        this.publicOut = new UncloseableOutputStream(this.out, new DelegateCloseHandler(this));
    }

    private void ensureOutputStream() throws IOException {
        if (this.out == null) {
            if (!this.opened) {
                try {
                    this.out = Streams.createBufferedFileOutputStream(this.file);
                }
                catch (FileNotFoundException e) {
                    throw new IOException("Couldn't open stream on target |" + this.name + "|: " + e.getMessage());
                }
                this.createPublicOutputStream();
            } else {
                throw new IOException("The stream of target |" + this.name + "| is already closed.");
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.ensureOutputStream();
        return this.publicOut;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        finally {
            this.publicOut = null;
            this.out = null;
        }
    }
}

